import * as mUserRealNameService from "../service/mUserRealName.service";
import { QueryVO } from "../service/mUserRealName.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId, getOneAclUserByUid, } from "../../../utils/aclUserUtils";

import { isLimitUserId } from "../../../utils/mUserCommonUtils";
import { AclUserInfoConst } from "../../../constant/aclUserConstant";

let isIp = require('is-ip');

/**
 * Madex 用户实名列表
 * @param req
 * @param infoVO
 */
export const kycList = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserRealNameCtrl.kycList";
    try {
        queryVO.page = Optional.opt(queryVO, 'page', 1);
        queryVO.size = Optional.opt(queryVO, 'size', 20);
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let dbInfo = await getOneAclUserByUid(currentUserId);
        let isAdmin = dbInfo.user_type == AclUserInfoConst.USER_TYPE.ADMIN

        let res = await mUserRealNameService.kycList(queryVO, isAdmin);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * Madex 单个实名用户详情
 * @param req
 * @param queryVO
 */
export const oneDetail = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserRealNameCtrl.oneDetail";
    try {
        if (!queryVO.id) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await mUserRealNameService.oneDetail(queryVO.id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * Madex 实名审核
 * @param req
 * @param queryVO
 */
export const audit = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserRealNameCtrl.audit";
    try {
        if (!queryVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let res = await mUserRealNameService.audit(queryVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


