import { financeMarketAccount, ormDB, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface FinanceAccountVO {
    id?: number;

    account?: string | any;

    remark?: string | any;

    init_asset?: number;

    apikey?: string | any;

    secret?: string | any;

    secret_pwd?: string | any;

    platform?: number;

    status?: number;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface FinanceAccountPageVO extends FinanceAccountVO {

    page?: number,

    size?: number,

}


export async function list(pageVO: FinanceAccountPageVO) {
    let where = {};

    let resList = await financeMarketAccount.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["id", "asc"]],
        raw: true
    });
    return resList;
}


export async function add(financeAccountVO: FinanceAccountVO, currentUserId: any, ip: any) {
    let dbOne = await financeMarketAccount.prototype.findOne({
        where: {
            account: financeAccountVO.account
        },
        raw: true
    });
    if (dbOne) {
        throw ErrorCode.DATA_EXIST;
    }

    financeAccountVO.createdAt = new Date();
    financeAccountVO.updatedAt = new Date();
    if (!financeAccountVO.status) {
        //默认可用
        financeAccountVO.status = 1;
    }

    await financeMarketAccount.prototype.create(financeAccountVO);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增账户', ip, JSON.stringify(financeAccountVO), '金融部-其他管理');
    return 'success';
}


export async function update(financeAccountVO: FinanceAccountVO, currentUserId: any, ip: any) {
    let exist = await financeMarketAccount.prototype.findOne({
        where: {
            id: financeAccountVO.id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }

    let dbOne = await financeMarketAccount.prototype.findOne({
        where: {
            account: financeAccountVO.account,
            id: { [ormDB.Op.ne]: financeAccountVO.id }
        },
        raw: true
    });

    if (dbOne) {
        throw ErrorCode.DATA_EXIST;
    }


    financeAccountVO.updatedAt = new Date();
    await financeMarketAccount.prototype.update(financeAccountVO, {
        where: {
            id: Number(financeAccountVO.id)
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '修改账户信息', ip, JSON.stringify(financeAccountVO), '金融部-其他管理');

    return 'success';
}

export async function del(id: number, currentUserId: any, ip: string | undefined) {
    let exist = await financeMarketAccount.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }

    await financeMarketAccount.prototype.destroy({
        where: {
            id: id
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '删除账户信息', ip, `id:${id}`, '金融部-其他管理');

    return 'success';
}



