import * as financeAccountService from "../service/fianceAccount.service";
import { FinanceAccountVO, FinanceAccountPageVO } from "../service/fianceAccount.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { coinType, contractPairs, spotPairs } from "@madex/ex-ts-dao";

let isIp = require('is-ip');
/**
 * 账户列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: FinanceAccountPageVO) => {
    let func_name = "financeAccount.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await financeAccountService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加新的账户
 * @param req
 * @param authConfigVO
 */
export const add = async (req: any, financeAccountVO: FinanceAccountVO) => {
    let func_name = "financeAccount.control.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(financeAccountVO);

        let res = await financeAccountService.add(financeAccountVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 修改账户信息
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, financeAccountVO: FinanceAccountVO) => {
    let func_name = "financeAccount.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!financeAccountVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        await paramValid(financeAccountVO);

        let res = await financeAccountService.update(financeAccountVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 删除账户信息
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, financeAccountVO: FinanceAccountVO) => {
    let func_name = "financeAccount.control.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!financeAccountVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await financeAccountService.del(financeAccountVO.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

async function paramValid(financeAccountVO: FinanceAccountVO) {
    if (!financeAccountVO.account || !financeAccountVO.init_asset || !financeAccountVO.apikey ||
        !financeAccountVO.secret || !financeAccountVO.secret_pwd ||
        !financeAccountVO.platform) {
        throw ErrorCode.PARAM_MISS;
    }
}

