import { ormDB, userInfo, userAccountChangeLog } from "@madex/ex-ts-dao";


export const existEmail = async function (email: string) {
    let where = {
        type: 1,//邮箱
        [ormDB.Op.or]: {
            account_old: email,
            account_new: email
        }
    }
    let dbInfo = await userAccountChangeLog.prototype.findOne({
        where: where,
        raw: true
    });
    return dbInfo
}


export const getProcessingEmailListByMUserId = async function (m_user_id: number) {
    let where = {
        type: 1,//邮箱,
        user_id: m_user_id,
        state: 3//状态 3 修改完成--可在7日内恢复成5
    }
    let dbInfoList = await userAccountChangeLog.prototype.findAll({
        where: where,
        raw: true
    });
    return dbInfoList
}
