import { ormDB, coinWithdraw, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";


export const getCoinWithdrawMapByUids = async function (uids: number[]) {
    if (!uids.length) {
        throw ErrorCode.PARAM_MISS;
    }
    let dbInfoList = await coinWithdraw.prototype.findAll({
        where: {
            user_id: { [ormDB.Op.in]: uids }
        },
        raw: true
    });

    let resMap = {};
    for (let item of dbInfoList) {
        resMap[item.user_id] = item
    }
    return resMap;
}