import { userApikeyStrict, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');
let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');


export interface MakerPairVO {
    id?: number,

    pair?: string;

    user_id?: number;

    enable?: number;

    data?: string

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface MakerPairPageVO extends MakerPairVO {

    page?: number,

    size?: number,
}


export async function list(pageVO: MakerPairPageVO) {
    let key = 'spotMarketMaker.service.list';
    //TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let list = await RedisClient.getSync(key);
    let res = {
        count: list ? list.length : 0,
        rows: list ? list : []
    }
    return res;
}


export async function set(makerPairVO: MakerPairVO, currentUserId: any, ip: string | undefined) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    makerPairVO.createdAt = new Date();
    makerPairVO.updatedAt = new Date();
    let key = 'spotMarketMaker.service.list';
    let list = await RedisClient.getSync(key);
    if (list) {
        makerPairVO.id = list.length + 1;
        list.push(makerPairVO);
    }
    else {
        makerPairVO.id = 1;
        list = [];
        list.push(makerPairVO);
    }
    await RedisClient.writeSync(key, list);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '现货做市参数配置-交易对新增', ip, JSON.stringify(makerPairVO), '现货做市参数配置');
    return 'success';
}

export async function paramGet(pair: string) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let key = 'spotMarketMaker.service.paramGet';
    let map = await RedisClient.getSync(key);
    let res = map ? map[pair] : ""
    return res;
}

export async function paramSet(pair: string, data: string, currentUserId: any, ip: any) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let key = 'spotMarketMaker.service.paramGet';
    let map = await RedisClient.getSync(key);
    if (!map) {
        map = {}
    }
    map[pair] = JSON.parse(data);

    await RedisClient.writeSync(key, map);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '现货做市参数配置-做市参数设置', ip, `pair:${pair},data:${data}`, '现货做市参数配置');
    return "ok";
}


