import * as abkFeeStatisticsService from "../../service/v2/abkFeeStatistics.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../../constant/errorCode";
import { beforeQueryCheckTime, CommonParam, setPageAndSize } from "../../service/v2/abkCommonService";

/**
 * 首页数据概览
 * @param req
 * @param commonParam
 */
export const gatherData = async (req: any, commonParam: CommonParam) => {
    let func_name = "abkFeeStatistics.control.gatherData";
    try {
        beforeQueryCheckTime(commonParam);
        let res = await abkFeeStatisticsService.gatherData(commonParam.from_time, commonParam.to_time);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 查询手续费数据
 * type 1 现货 2 U本位合约 3 币本位合约 4 全部
 * @param req
 * @param commonParam
 */
export const getFeeData = async (req: any, commonParam: CommonParam) => {
    let func_name = "abkFeeStatistics.control.getFeeData";
    try {
        setPageAndSize(commonParam);
        beforeQueryCheckTime(commonParam);
        let type = Number(commonParam.query_type) || 4;
        let res = await abkFeeStatisticsService.getFeeData(commonParam.from_time, commonParam.to_time, commonParam.page, commonParam.size, type);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 提现手续费
 * @param req
 * @param commonParam
 */
export const withdrawData = async (req: any, commonParam: CommonParam) => {
    let func_name = "abkFeeStatistics.control.withdrawData";
    try {
        setPageAndSize(commonParam);
        beforeQueryCheckTime(commonParam);
        let res = await abkFeeStatisticsService.withdrawData(commonParam.from_time, commonParam.to_time,commonParam.page,commonParam.size);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



