/**
 * 资产管理后台路由
 */
import Express from "express"

const {
    Res3Utils,
    logger,
} = require("@madex/ex-js-public");
const router = Express.Router();


import * as  abkUserCtrl from "../../mvc/control/v2/abkUserInfo.control";
import * as  assetCheckCtrl from "../../mvc/control/v2/assetCheck.control";
import * as  feeStatisticsCtrl from "../../mvc/control/v2/abkFeeStatistics.control";
import Config from "../../../../config";


const postFunc = {
    //账号管理
    'abkUser/login': abkUserCtrl.login,//登陆
    'abkUser/logout': abkUserCtrl.logout,//登出
    'abkUser/getInfo': abkUserCtrl.getInfo,//当前登陆用户信息
    'abkUser/getInfoDetailByUserId': abkUserCtrl.getInfoDetailByUserId,//用户信息详情
    'abkUser/reset/totp': abkUserCtrl.resetTotp,//重置谷歌
    'abkUser/get/totp': abkUserCtrl.getTotp,//获取谷歌
    'abkUser/list': abkUserCtrl.userList,//用户列表
    'abkUser/updateStatus': abkUserCtrl.updateStatus,//更新用户状态
    'abkUser/addUser': abkUserCtrl.addAbkUser,//添加用户
    //资产对账
    'assetCheck/userAddrList': assetCheckCtrl.userAddrList,//用户地址
    'assetCheck/assetDetails': assetCheckCtrl.assetDetails,//资产明细
    'assetCheck/siteAssets': assetCheckCtrl.siteAssets,//站内资产
    'assetCheck/depositList': assetCheckCtrl.depositList,//实时充值
    'assetCheck/withdrawList': assetCheckCtrl.withdrawList,//实时提现
    //收入分析
    'abkFeeStatistics/home/gatherData': feeStatisticsCtrl.gatherData,//首页数据概览
    'abkFeeStatistics/getFeeData': feeStatisticsCtrl.getFeeData,//平台、现货、合约 手续费查询
    'abkFeeStatistics/withdrawData': feeStatisticsCtrl.withdrawData,//提现手续费
/*
    'user/login/confirm': userOptCtrl.loginConfirm,
    'user/bind/totp/ask': userOptCtrl.bindTotpAsk,
    'user/bind/totp/confirm': userOptCtrl.bindTotpConfirm,
    'user/auth/reset/totp': userAuthConfigCtrl.resetTotp,*/


};


router.post('/*', (req, res, next) => {
    //去除前缀
    let path = req.originalUrl.replace(Config.BASE_ABK_URL, "");
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!postFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.body, postFunc[path]);

});

const doJob = (req, res, next, param, func) => {

    let _func_name_ = 'router.doJob';

    func(req, param, res).then(data => {
        res.json(data);
    }).catch(err => { // 可以抛出错误码
        logger.error(_func_name_, err);
        return Res3Utils.responseError(err, res);
    });
};

export const apiRouterV2 = router;
