// @madex/ex-ts-dao 是 ts 的 dao, 代码在 bitbucket/ex-js-dao 的 ts 分支上
import { i18nInfo, i18nInfoLog, ormDB } from "@madex/ex-ts-dao";
import * as i18nService from "./i18n.service";
import { I18nInfoPageVO, I18nInfoVO } from "./i18n.service";

export interface I18nInfoLogVO extends I18nInfoPageVO {
    info_id?: number;
}


export async function list(i18nInfoLogVO: I18nInfoLogVO) {

    if (i18nInfoLogVO.code) {
        i18nInfoLogVO.code = { [ormDB.Op.like]: `${i18nInfoLogVO.code}%` };
    }

    if (i18nInfoLogVO.sub_code) {
        i18nInfoLogVO.sub_code = { [ormDB.Op.like]: `${i18nInfoLogVO.sub_code}%` };
    }
    if (i18nInfoLogVO.desc) {
        i18nInfoLogVO.desc = { [ormDB.Op.like]: `${i18nInfoLogVO.desc}%` };
    }
    if (i18nInfoLogVO.updatedAt) {
        i18nInfoLogVO.updatedAt = { [ormDB.Op.gte]: new Date(i18nInfoLogVO.updatedAt).getTime() };
    }
    let page = Number(i18nInfoLogVO.page);
    let size = Number(i18nInfoLogVO.size);
    let where = Object.assign(i18nInfoLogVO);
    delete i18nInfoLogVO.page;
    delete i18nInfoLogVO.size;
    let resList = await i18nInfoLog.prototype.findAndCount({
        where: where,
        limit: size,
        offset: (page - 1) * size,
        order: [["updatedAt", "desc"]],
        raw: true
    });
    return resList;
}

export const add = async (infoLogVO: any, tx: any) => {
    if (!infoLogVO.createdAt) {
        infoLogVO.createdAt = new Date();
    }
    if (!infoLogVO.updatedAt) {
        infoLogVO.updatedAt = new Date();
    }
    await i18nInfoLog.prototype.create(infoLogVO, {
        transaction: tx,
    });
};

export async function revert(i18nInfoLogVO: I18nInfoLogVO) {
    let dbOneI18nInfoLog = await i18nInfoLog.prototype.findOne({
        raw: true,
        where: {
            id: i18nInfoLogVO.id
        }
    });
    if (!dbOneI18nInfoLog) {
        throw '3246';
    }
    let infoId = dbOneI18nInfoLog.info_id;

    let dbOneI18nInfo = await i18nInfo.prototype.findOne({
        raw: true,
        where: {
            id: infoId
        }
    });
    let itemInfo = {
        platform: dbOneI18nInfoLog.platform,
        module: dbOneI18nInfoLog.module,
        code: dbOneI18nInfoLog.code,
        sub_code: dbOneI18nInfoLog.sub_code,
        lang: dbOneI18nInfoLog.lang,
        desc: dbOneI18nInfoLog.desc,
        content: dbOneI18nInfoLog.content,
        createdAt: dbOneI18nInfoLog.createdAt,
        updatedAt: dbOneI18nInfoLog.updatedAt,
    }
    if (!dbOneI18nInfo) {
        await i18nService.add(itemInfo);
        return 'ok';
    }
    else {
        delete itemInfo.createdAt;
        await i18nInfo.prototype.update(itemInfo, {
            where: {
                id: infoId
            }
        });
        return 'ok';
    }

}