import Express from "express"

const router = Express.Router();


import * as userController from "../../mvc/control/user.control";
import * as i18nCtrl from "../../mvc/control/i18n.control";
import * as i18nLogCtrl from "../../mvc/control/i18nlog.control";

const getFunc = {
    'user/info': userController.getUserInfo,
};

const postFunc = {
    'i18n/info/list': i18nCtrl.list,
    'i18n/info/add': i18nCtrl.add,
    'i18n/info/update': i18nCtrl.update,
    'i18n/info/del': i18nCtrl.del,

    'i18n/info/log/list': i18nLogCtrl.list,
    'i18n/info/log/revert': i18nLogCtrl.revert,
};


let getErrorMessage = (code: number, message?: string) => {
    return {
        code: code,
        msg: message,
        data: [],
    };
};

// TODO 这里先和 nodejs 的注册路由方式保持一样，后面在调整。

router.get('/*', (req, res, next) => {
    let path = req.path ? req.path.slice(1) : '';
    if (!path) {
        return res.json(getErrorMessage(3000));
    }

    if (!getFunc[path]) {
        return res.json(getErrorMessage(3000));
    }

    doJob(req, res, next, req.query, getFunc[path]);
});

router.post('/*', (req, res, next) => {
    const path = req.path ? req.path.slice(1) : '';
    if (!path) {
        return res.json(getErrorMessage(3000));
    }

    if (!postFunc[path]) {
        return res.json(getErrorMessage(3000));
    }

    doJob(req, res, next, req.body, postFunc[path]);

});

const doJob = (req, res, next, param, func) => {

    let _func_name_ = 'router.doJob';

    func(req, param).then(data => {
        res.json(data);
    }).catch(err => { // 可以抛出错误码
        console.error(_func_name_, err);
        // if (isValidResponseData(err)) {
        //     res.json(err);
        //     return;
        // }
        // if (!err || !errorCodeDefine[err]) {
        //     err = errCode.CODE_INTERNAL;
        // }
        return res.json(getErrorMessage(3000));
    });
};

export const apiRouterV1 = router;
