// @madex/ex-ts-dao 是 ts 的 dao, 代码在 bitbucket/ex-js-dao 的 ts 分支上
import { coinType, ormDB, spotPairs } from "@madex/ex-ts-dao";
import { addCoin2Core } from "../../../utils/coreSystemUtils";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";

let { logger, datetimeUtils } = require('@madex/ex-js-public');

export interface ListParam {
    symbol: string | any;

    page: number;

    size: number;

    status?: number

    from_time?: Date | any

    to_time?: Date | any
}

export interface AddParam {
    id: any,

    symbol: string;

    is_active: number;

    is_main: number;

    name: string;

    general_name: string;

    chain_type?: string;

    issupport_memo?: number;

    original_decimals: number;

    valid_decimals: number;

    contract?: string;

    contract_father?: string;

    enable_deposit?: number;

    enable_withdraw?: number;

    enable_transfer?: number;

    withdraw_fee?: number;

    withdraw_min?: number;

    deposit_min?: number;

    deposit_confirm_count: number;

    safe_confirm_count: number;

    explor_url?: string;

    icon_url?: string;

    describe_url?: string;

    weight?: number;

    forbid_info?: string;

    describe_summary?: string;

    total_amount?: number;


    supply_amount?: number;

    circulation_rate?: number;

    address_num?: number;

    price?: string;

    supply_time?: string;

    deflation_rate?: number;

    comment?: string;

    max_transfer_amount?: number;

    tag: string;

    forbid_info_related?: number;

    is_hidden?: number;

    main_status?: number;

    createdAt?: Date | any,

    updatedAt?: Date | any,
}


export async function list(param: ListParam) {
    let where = {};
    if (param.symbol) {
        where["symbol"] = { [ormDB.Op.like]: `%${param.symbol}%` };
    }
    if (param.status || param.status === 0) {
        where["main_status"] = param.status
    }
    if (param.from_time && param.to_time) {
        where['createdAt'] = { [ormDB.Op.between]: [param.from_time, param.to_time] }
    }
    let resList = await coinType.prototype.findAndCount({
        where: where,
        limit: param.size,
        offset: (param.page - 1) * param.size,
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}

export const save = async (param: AddParam, currentUserId: any, ip: any) => {
    if (!param.weight) {
        param.weight = 0;
    }
    param.updatedAt = new Date();
    param.createdAt = new Date();
    await coinType.prototype.create(param);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '币种管理新增', ip, JSON.stringify(param), '币种管理');
    return 'ok';
};

export const update = async (param: AddParam, currentUserId: any, ip: any) => {
    let id = param.id;
    let dbInfo = await coinType.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });
    if (!dbInfo) {
        throw ErrorCode.DATA_NOT_EXIST
    }
    param.updatedAt = new Date();
    await coinType.prototype.update(param, {
        where: { id: id }
    })
    //管理后台操作日志
    addOptLog(currentUserId, 0, '币种管理更新', ip, JSON.stringify(param), '币种管理');
    return 'ok';
};

export const pushToCoreSystem = async (id: any, currentUserId: any, ip: any) => {

    let where = { id: id, main_status: 0, is_main: 1 };

    let cfg = await coinType.prototype.find({
        where: where, raw: true
    });
    if (!cfg) {
        throw ErrorCode.SUBMIT_STATUS_OR_MAIN_ERR;
    }
    let symbol = cfg.general_name;

    let optResult = await addCoin2Core(symbol, cfg.id);
    if (!optResult.is_success) {
        //管理后台操作日志
        addOptLog(currentUserId, 0, '提交币种到撮合-失败', ip, `symbol:${symbol},error_msg:${optResult.err_msg}`, '币种管理');
        throw ErrorCode.ADD_PAIR_TO_CORE_ERR;
    }
    await coinType.prototype.update({ main_status: 1 }, {
        where: where
    });
    //管理后台操作日志
    addOptLog(currentUserId, 0, '提交币种到撮合-成功', ip, `symbol:${symbol}`, '币种管理');
    return 'ok';

};

export async function getAllSubmitSuccess() {
    let resList = await coinType.prototype.findAll({
        where: {
            main_status: 2
        },
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}