import { userApikeyStrict, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');
let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');


export interface AgentVO {
    id?: number,

    user_id?: number;

    adl_type?: number;

    enable?: number;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}

export interface AgentUserVO {
    id?: number,

    user_id?: number;

    agent_id?: number;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface AgentPageVO extends AgentVO, AgentUserVO {

    page?: number,

    size?: number,

}


export async function agentList(pageVO: AgentPageVO) {
    let key = 'contractAgent.service.agentList';
    //TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let list = await RedisClient.getSync(key);
    let res = {
        count: list ? list.length : 0,
        rows: list ? list : []
    }
    return res;
}


export async function agentSet(agentVO: AgentVO, currentUserId: any, ip: string | undefined) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    agentVO.createdAt = new Date();
    agentVO.updatedAt = new Date();
    let key = 'contractAgent.service.agentList';
    let list = await RedisClient.getSync(key);
    if (list) {
        agentVO.id = list.length + 1;
        list.push(agentVO);
    }
    else {
        agentVO.id = 1;
        list = [];
        list.push(agentVO);
    }
    await RedisClient.writeSync(key, list);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '合约接单账户配置', ip, JSON.stringify(agentVO), '合约接单账户配置');
    return 'success';
}


export async function agentUserList(pageVO: AgentPageVO) {
    let key = 'contractAgent.service.agentUserList';
    //TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let list = await RedisClient.getSync(key);
    let res = {
        count: list ? list.length : 0,
        rows: list ? list : []
    }
    return res;
}


export async function agentUserSet(agentUserVO: AgentUserVO, currentUserId: any, ip: string | undefined) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    agentUserVO.createdAt = new Date();
    agentUserVO.updatedAt = new Date();
    let key = 'contractAgent.service.agentUserList';
    let list = await RedisClient.getSync(key);
    if (list) {
        agentUserVO.id = list.length + 1;
        list.push(agentUserVO);
    }
    else {
        agentUserVO.id = 1;
        list = [];
        list.push(agentUserVO);
    }
    await RedisClient.writeSync(key, list);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '合约接单账户关联配置', ip, JSON.stringify(agentUserVO), '合约接单账户关联');
    return 'success';
}

export async function agentChannelList(pageVO: AgentPageVO) {
    let key = 'contractAgent.service.agentChannelList';
    //TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let list = await RedisClient.getSync(key);
    let res = {
        count: list ? list.length : 0,
        rows: list ? list : []
    }
    return res;
}


export async function agentChannelSet(agentUserVO: AgentUserVO, currentUserId: any, ip: string | undefined) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    agentUserVO.createdAt = new Date();
    agentUserVO.updatedAt = new Date();
    let key = 'contractAgent.service.agentChannelList';
    let list = await RedisClient.getSync(key);
    if (list) {
        agentUserVO.id = list.length + 1;
        list.push(agentUserVO);
    }
    else {
        agentUserVO.id = 1;
        list = [];
        list.push(agentUserVO);
    }
    await RedisClient.writeSync(key, list);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '合约渠道用户配置', ip, JSON.stringify(agentUserVO), '合约渠道用户管理');
    return 'success';
}


