import * as assetCheckService from "../../service/v2/assetCheck.service";
import { CommonParam ,setPageAndSize} from "../../service/v2/abkCommonService";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../../constant/errorCode";

/**
 * 用户地址列表
 * @param req
 * @param commonParam
 */
export const userAddrList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.userAddrList";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.userAddrList(commonParam.page, commonParam.size, commonParam.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 资产分布
 * @param req
 * @param commonParam
 */
export const assetDetails = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.assetDetails";
    try {
        setPageAndSize(commonParam);
        if (!commonParam.user_id){
            throw ErrorCode.PARAM_MISS;
        }
        let res = await assetCheckService.assetDetails(commonParam.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 站内资金
 * @param req
 * @param commonParam
 */
export const siteAssets = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.siteAssets";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.siteAssets(commonParam.page,commonParam.size);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 实时充值记录
 * @param req
 * @param commonParam
 */
export const depositList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.depositList";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.depositList(commonParam.page,commonParam.size,commonParam.uid_or_addr);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 实时提现记录
 * @param req
 * @param commonParam
 */
export const withdrawList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.withdrawList";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.withdrawList(commonParam.page,commonParam.size,commonParam.uid_or_addr);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};




