import { ormDB, userInfo, userAccountOperateLog, aclUserInfo } from "@madex/ex-ts-dao";


export const TYPE = {
    //google密钥
    GOOGLE_KEY: 0,
    //2小时限制
    TWO_HOUR_LIMIT: 1,
    //24小时限制
    TWENTY_FOUR_HOUR_LIMIT: 2,
    //邮箱
    MAIL: 3,
    //最大提现额度
    MAXIMUM_WITHDRAWAL_AMOUNT: 4,
    //账户状态
    ACCOUNT_STATUS: 5,
    //能否提现修改
    CAN_WITHDRAW_AND_MODIFY: 6,
    //账户激活状态
    ACCOUNT_ACTIVATION_STATUS: 7,
    //备注
    REMARK: 8,
    //实名
    KYC: 9
}
export const recordMUserOperateLog = async function (m_user_id: number, operate_user_id: number, operate_type: number,
                                                comment: string, before_v: string, after_v: string) {
    let aclUser = await aclUserInfo.prototype.findOne({
        where: {
            user_id: operate_user_id
        }
    });
    let operate_user_name = aclUser.account ? aclUser.account : operate_user_id;

    await userAccountOperateLog.prototype.create({
        user_id: m_user_id,
        operate_user_id: operate_user_id,
        operate_user_name: operate_user_name,
        operate_type: operate_type,
        operational_situation: comment,
        before_value: before_v,
        after_value: after_v,
        createdAt: new Date(),
        updatedAt: new Date()
    });

}