import Express from "express"

const {
    Res3Utils,
    logger,
} = require("@madex/ex-js-public");
const router = Express.Router();


import * as userController from "../../mvc/control/user.control";
import * as i18nCtrl from "../../mvc/control/i18n.control";
import * as i18nLogCtrl from "../../mvc/control/i18nlog.control";
import * as  aclUserCtrl from "../../mvc/control/aclUser.control";
import * as  aclRoleAuthCtrl from "../../mvc/control/aclRoleAuth.control";
import * as  userOptCtrl from "../../mvc/control/userOpt.control";
import * as  userAuthConfigCtrl from "../../mvc/control/userAuthConfig.control";
import * as  hotPairConfigCtrl from "../../mvc/control/hotPairConfig.control";
import * as ReqUtils from "../../../utils/req-utils";

import * as spotPairCtrl from "../../mvc/control/spotPair.control";
import * as coinTypeCtrl from "../../mvc/control/coinType.control";
import * as noticeCtrl from "../../mvc/control/notice.control";
import * as mUserOptLogCtrl from "../../mvc/control/mUserOptLog.control";
import * as mUserManageCtrl from "../../mvc/control/mUserManage.control";
import * as mUserRealNameCtrl from "../../mvc/control/mUserRealName.control";
import * as usefulLinkCtrl from "../../mvc/control/usefulLink.control";
import * as mUserSubscribeCtrl from "../../mvc/control/mUserSubscribe.control";
const getFunc = {
    'user/info': userController.getUserInfo,
};

const postFunc = {
    //国际化
    'i18n/info/list': i18nCtrl.list,
    'i18n/info/add': i18nCtrl.add,
    'i18n/info/update': i18nCtrl.update,
    'i18n/info/del': i18nCtrl.del,
    'i18n/info/log/list': i18nLogCtrl.list,
    'i18n/info/log/revert': i18nLogCtrl.revert,

    'spotPair/add': spotPairCtrl.save,
    'spotPair/list': spotPairCtrl.list,
    'spotPair/spotPairCtl': spotPairCtrl.pushToCoreSystem,

    'coinType/add': coinTypeCtrl.save,
    'coinType/list': coinTypeCtrl.list,
    'coinType/spotPairCtl': coinTypeCtrl.pushToCoreSystem,

    //权限管理
    'acl/user/add': aclUserCtrl.add,
    'acl/user/list': aclUserCtrl.list,
    'acl/user/update': aclUserCtrl.update,
    'acl/user/updateStatus': aclUserCtrl.updateStatus,
    'acl/user/resetPwd': aclUserCtrl.resetPwd,
    'acl/auth/list': aclRoleAuthCtrl.authList,
    'acl/auth/tree': aclRoleAuthCtrl.getAuthTree,
    'acl/auth/getByUser': aclRoleAuthCtrl.getAuthByUser,
    'acl/auth/getByRole': aclRoleAuthCtrl.getAuthByRole,
    'acl/auth/save': aclRoleAuthCtrl.saveAuth,
    'acl/auth/del': aclRoleAuthCtrl.delAuth,

    //角色管理
    'acl/role/list': aclRoleAuthCtrl.roleList,
    'acl/role/getByUser': aclRoleAuthCtrl.getRoleByUser,
    //'acl/role/getUserList':aclUserCtrl.list,
    'acl/role/getAll': aclRoleAuthCtrl.getAllRole,
    'acl/role/save': aclRoleAuthCtrl.saveRole,
    'acl/role/del': aclRoleAuthCtrl.delRole,
    'acl/changeRoleAuth': aclRoleAuthCtrl.changeRoleAuth,
    'acl/changeUserRole': aclRoleAuthCtrl.changeUserRole,

    //管理后台用户管理
    'user/getInfo': userOptCtrl.getInfo,
    'user/login': userOptCtrl.login,
    'user/logout': userOptCtrl.logout,
    'user/login/confirm': userOptCtrl.loginConfirm,
    'user/updatePwd': userOptCtrl.updatePwd,
    'user/bind/totp/ask': userOptCtrl.bindTotpAsk,
    'user/bind/totp/confirm': userOptCtrl.bindTotpConfirm,
    'user/auth/config/list': userAuthConfigCtrl.authConfigList,
    'user/auth/change/force/status': userAuthConfigCtrl.changeForceStatus,
    'user/auth/change/locked/status': userAuthConfigCtrl.changeLockedStatus,
    'user/auth/reset/totp': userAuthConfigCtrl.resetTotp,

    //热门交易对搜索
    'hot/pair/config/list': hotPairConfigCtrl.list,
    'hot/pair/config/add': hotPairConfigCtrl.add,
    'hot/pair/config/update': hotPairConfigCtrl.update,
    'hot/pair/config/del': hotPairConfigCtrl.del,

    //消息通知
    'notice/list': noticeCtrl.list,
    'notice/add': noticeCtrl.add,
    'notice/update': noticeCtrl.update,

    //日志和审计
    'mUser/opt/log/list':mUserOptLogCtrl.list,//Madex 用户操作日志列表
    //Madex 用户管理
    'mUser/manage/userList': mUserManageCtrl.userList,//Madex 用户管理 ->用户列表
    'mUser/manage/oneUserDetail': mUserManageCtrl.oneUserDetail,//Madex 用户管理 ->单个用户详情
    'mUser/manage/updateUserEmail': mUserManageCtrl.updateUserEmail,//Madex 用户管理 ->修改用户邮箱
    'mUser/manage/lockAccount': mUserManageCtrl.lockAccount,//Madex 用户管理 ->锁定账户
    'mUser/manage/unlockAccount': mUserManageCtrl.unlockAccount,//Madex 用户管理 ->解锁账户
    'mUser/manage/clearLoginLimit': mUserManageCtrl.clearLoginLimit,//Madex 用户管理 ->清除登陆限制
    'mUser/manage/clear24WithdrawLimit': mUserManageCtrl.clear24WithdrawLimit,//Madex 用户管理 ->清除24小时提现限制
    'mUser/manage/kyc/list': mUserRealNameCtrl.kycList,//Madex 用户管理 ->实名认证列表
    'mUser/manage/kyc/oneDetail': mUserRealNameCtrl.oneDetail,//Madex 用户管理 ->kyc详情
    'mUser/manage/kyc/audit': mUserRealNameCtrl.audit,//Madex 用户管理 ->kyc审核

    //资源位管理
    'link/useful/list': usefulLinkCtrl.list,//链接记录列表
    'link/useful/add': usefulLinkCtrl.add,//添加链接记录
    'link/useful/delete': usefulLinkCtrl.del,//删除链接记录
    'link/useful/update': usefulLinkCtrl.update,//修改链接记录
    'link/useful/detail': usefulLinkCtrl.detail,//链接记录详情

    //邮件订阅
    'mUser/subscribe/list': mUserSubscribeCtrl.list,//订阅列表
    'mUser/subscribe/delete': mUserSubscribeCtrl.del,//删除订阅
    'mUser/subscribe/count': mUserSubscribeCtrl.count,//订阅统计
    'mUser/subscribe/mail/history': mUserSubscribeCtrl.history,//发送历史
    'mUser/subscribe/mail/send': mUserSubscribeCtrl.mailSend,//邮件发送
    'mUser/subscribe/mail/detail': mUserSubscribeCtrl.mailDetail,//发送详情
    'mUser/subscribe/mail/send/group': mUserSubscribeCtrl.maiSendGroup,//群发邮件




};

// TODO 这里先和 nodejs 的注册路由方式保持一样，后面在调整。

router.get('/*', (req, res, next) => {
    let path = ReqUtils.parsePath(req.originalUrl);
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!getFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.query, getFunc[path]);
});

router.post('/*', (req, res, next) => {
    let path = ReqUtils.parsePath(req.originalUrl);
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!postFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.body, postFunc[path]);

});

const doJob = (req, res, next, param, func) => {

    let _func_name_ = 'router.doJob';

    func(req, param, res).then(data => {
        res.json(data);
    }).catch(err => { // 可以抛出错误码
        logger.error(_func_name_, err);
        return Res3Utils.responseError(err, res);
    });
};

export const apiRouterV1 = router;
