'use strict';

/**
 * 资产管理后台-钱包对账、程序自动对账告警
 */
const schedule = require('node-schedule');
let { logger, datetimeUtils } = require('@madex/ex-js-public');

import * as service from "../service/task.abk.asset.check.warning.service";
let running1 = false;

/**
 *  程序自动对账
 *  每10分钟跑一次
 */
let autoCheckJob = schedule.scheduleJob('0 */10 * * * *', async function () {
    logger.info('autoCheckJob start');
    if (!running1) {
        try {
            running1 = true;
            let now = new Date();
            let end_time_ts = now.getTime();
            let start_time_ts = datetimeUtils.sub(now, datetimeUtils.DAY * 10).getTime();
            await service.balanceAndFundingInOutCheck(start_time_ts,end_time_ts);
            logger.info("autoCheckJob job finish");
        }
        catch (e) {
            logger.info(e)
        }
        running1 = false;
    }
});
autoCheckJob.invoke();