/* ======================================================================
 * 市商、普通用户、KOL费率设置纪录状态更新。
 * ====================================================================== */


import { commonUserFeeSettingStatusUpdateService } from "../service/task.fee.setting.status.update.service";

let schedule = require('node-schedule');
let { logger } = require('@madex/ex-js-public');

let userSettingUpdateRunning = false;

/**
 * 市商、普通用户、KOL 费率设置纪录状态更新。
 * 每10分钟更新一次。
 */
let userSettingStatusUpdate = schedule.scheduleJob('0 */10 * * * *', async function () {
    try {
        logger.info('task_fee_setting_status_update userSettingStatusUpdate start');
        if (!userSettingUpdateRunning) {
            userSettingUpdateRunning = true;
            await commonUserFeeSettingStatusUpdateService();
            userSettingUpdateRunning = false;
        }
    }
    catch (error) {
        userSettingUpdateRunning = false;
        logger.warn('task_fee_setting_status_update userSettingStatusUpdate error', error);
    }
});