// @madex/ex-ts-dao 是 ts 的 dao, 代码在 bitbucket/ex-js-dao 的 ts 分支上
import { spotPairs, ormDB } from "@madex/ex-ts-dao";
import { NUMBER } from "sequelize";


export interface ListParam {
    symbol: string | any;
    page: number;
    size: number;
}

export interface AddParam {
    base:string;
    quote:string;
    symbol:string;
    name:string;
    price_scale:number;
    quantity_scale:number;
    maker_fee:string;
    taker_fee: string;
}


export async function list(param: ListParam) {
    let where = {};
    if (param.symbol) {
        where["symbol"]=  { [ormDB.Op.like]: `%${param.symbol}%` };
    }
    let resList = await spotPairs.prototype.findAndCount({
        where: where,
        limit: param.size,
        offset: (Number(param.page) - 1) * Number(param.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}

export const add = async (param: AddParam) => {
    await spotPairs.prototype.create(param);
    return 'ok';
};

