import * as hotPairConfigService from "../service/hotPairConfig.service";
import { HotPairConfigVO, HotPairConfigPageVO } from "../service/hotPairConfig.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId, isAdminUserBySessionId } from "../../../utils/aclUserUtils";

/**
 * 分页查询热门交易对配置列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, hotPairConfigPageVO: HotPairConfigPageVO) => {
    let func_name = "hotPairConfigCtrl.list";
    try {
        hotPairConfigPageVO.page = Optional.opt(hotPairConfigPageVO, 'page', 1);
        hotPairConfigPageVO.size = Optional.opt(hotPairConfigPageVO, 'size', 20);
        let res = await hotPairConfigService.list(hotPairConfigPageVO.pair, Number(hotPairConfigPageVO.page), Number(hotPairConfigPageVO.size));
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加热门交易对
 * @param req
 * @param infoVO
 */
export const add = async (req: any, hotPairConfigVO: HotPairConfigVO) => {
    let func_name = "hotPairConfigCtrl.add";
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, hotPairConfigVO.pair);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, hotPairConfigVO.weight);
        let res = await hotPairConfigService.add(hotPairConfigVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 修改热门交易对
 * @param req
 * @param infoVO
 */
export const update = async (req: any, hotPairConfigVO: HotPairConfigVO) => {
    let func_name = "hotPairConfigCtrl.update";
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, hotPairConfigVO.id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, hotPairConfigVO.pair);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, hotPairConfigVO.weight);
        let res = await hotPairConfigService.update(hotPairConfigVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 删除门交易对
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, hotPairConfigVO: HotPairConfigVO) => {
    let func_name = "hotPairConfigCtrl.del";
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, hotPairConfigVO.id);
        let res = await hotPairConfigService.del(Number(hotPairConfigVO.id));
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};