// @madex/ex-ts-dao 是 ts 的 dao, 代码在 bitbucket/ex-js-dao 的 ts 分支上
import { ormDB, hotPairConfig } from "@madex/ex-ts-dao";
import { AclUserInfoConst } from "../../../constant/aclUserConstant";
import { CryptUtils } from "../../../utils/crypt-utils";
import { ErrorCode } from "../../../constant/errorCode";
import * as aclRoleAuthService from "../service/aclRoleAuth.service";
import * as aclUserService from "../service/aclUser.service";
import { getOneAclUserByAccount, getOneAclUserByUid } from "../../../utils/aclUserUtils";
import { RedisVal } from "../../../constant/redis-val";
import Config from "../../../../config";
import { AuthConfigConst } from "../../../constant/aclUserAuthConfigConstant";
import * as userOptLogService from "./userOptLog.service";


let { apiAssertUtils: ApiAssert, datetimeUtils: DatetimeUtils } = require('@madex/ex-js-public');
let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, BigNumberUtils } = require('@madex/ex-js-common');

let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface HotPairConfigVO {
    id?: number;

    pair?: string | any;

    weight?: number;

    createdAt?: Date | any;

    updatedAt?: Date | any;


}

export interface HotPairConfigPageVO extends HotPairConfigVO {
    page?: number,

    size?: number
}

export async function list(pair: any, page: number, size: number) {
    let where = Object.create(null);
    if (pair) {
        where.pair = { [ormDB.Op.like]: `${pair}%` };
    }

    let resList = await hotPairConfig.prototype.findAndCount({
        where: where,
        limit: size,
        offset: (page - 1) * size,
        order: [["weight", "desc"]],
        raw: true
    });
    return resList;
}

export async function add(hotPairConfigVO: HotPairConfigVO) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            pair: hotPairConfigVO.pair
        },
        raw: true
    });

    if (dbInfo) {
        throw ErrorCode.DATA_EXIST;
    }
    hotPairConfigVO.createdAt = new Date();
    hotPairConfigVO.updatedAt = new Date();

    await hotPairConfig.prototype.create(hotPairConfigVO);
    return 'success'
}


export async function update(hotPairConfigVO: HotPairConfigVO) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            pair: hotPairConfigVO.pair,
            id: { [ormDB.Op.ne]: hotPairConfigVO.id }
        },
        raw: true
    });

    if (dbInfo) {
        throw ErrorCode.DATA_EXIST;
    }
    hotPairConfigVO.updatedAt = new Date();

    await hotPairConfig.prototype.update({
        pair: hotPairConfigVO.pair,
        weight: hotPairConfigVO.weight
    }, {
        where: {
            id: Number(hotPairConfigVO.id)
        }
    });
    return 'success'
}


export async function del(id: number) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });

    if (!dbInfo) {
        throw ErrorCode.DATA_NOT_EXIST;
    }

    await hotPairConfig.prototype.destroy({
        where: {
            id: Number(id)
        }
    });
    return 'success'
}



