import * as service from "../service/mUserOrderPendingAndHistory.service";
import { QueryVo } from "../service/mUserOrderPendingAndHistory.service";
import { getCurrentUserId, } from "../../../utils/aclUserUtils";
import { ErrorCode } from "../../../constant/errorCode";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');

/**
 * 现货当前委托列表
 * @param req
 * @param infoVO
 */
export const pendingList = async (req: any, queryVo: QueryVo) => {
    let func_name = "pendingAndHistoryCtrl.pendingList";
    try {
        if (!queryVo.user_id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await service.pendingList(queryVo);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 现货历史委托列表
 * @param req
 * @param infoVO
 */
export const historyList = async (req: any, queryVo: QueryVo) => {
    let func_name = "pendingAndHistoryCtrl.historyList";
    try {
        if (!queryVo.user_id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await service.historyList(queryVo);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 现货成交记录列表
 * @param req
 * @param infoVO
 */
export const detailList = async (req: any, queryVo: QueryVo) => {
    let func_name = "pendingAndHistoryCtrl.detailList";
    try {
        if (!queryVo.user_id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await service.detailList(queryVo);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



