import { exPairApply, coinType, ormDB, systemTrigger, spotPairs, exTradeArea, exBusinessAreaRouter, contractPairs } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";
import { PAIR_APPLY_STATUS } from "../../../constant/pairApplyConst";


let _ = require('lodash');
let { logger, datetimeUtils } = require('@madex/ex-js-public');


export interface CronApplyVO {
    id?: number;

    trigger_symbol?: string;

    trigger_type?: number;

    trigger_action?: number;

    trigger_time?: Date | any;

    status?: number;

    is_active?: number;

    is_hide?: number;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface CronApplyPageVO extends CronApplyVO {

    page?: number,

    size?: number,

}


export async function list(pageVO: CronApplyPageVO) {

    let resList = await systemTrigger.prototype.findAndCount({
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}


export async function del(id: number, currentUser: any, ip: string | undefined) {


    let dbInfo = await systemTrigger.prototype.findOne({
        where: { id: id },
        raw: true
    });
    if (!dbInfo) {
        throw ErrorCode.DATA_NOT_EXIST
    }
    if (dbInfo && dbInfo.status != 0) {
        throw ErrorCode.NO_TRIGGER_DEL
    }
    await systemTrigger.prototype.destroy({
        where: {
            id: id
        }
    });
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '删除审核上币定时器', ip, JSON.stringify(dbInfo), '交易上下线管理');
    return 'success';
}


export async function addDeposit(cronApplyVO: CronApplyVO, currentUser: any, ip: any) {

    let dbCoin = await coinType.prototype.findOne({
        where: {
            symbol: cronApplyVO.trigger_symbol
        },
        raw: true
    });
    if (!dbCoin) {
        throw ErrorCode.COIN_DATA_NOT_EXIST
    }
    cronApplyVO.trigger_type = 1;
    cronApplyVO.trigger_action = 1021;
    cronApplyVO.status = 0;
    cronApplyVO.createdAt = new Date();
    cronApplyVO.updatedAt = new Date();
    await systemTrigger.prototype.create(cronApplyVO);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '增加新币充值定时器', ip, JSON.stringify(cronApplyVO), '交易上下线管理');
    return 'success';
}


export async function addWithdraw(cronApplyVO: CronApplyVO, currentUser: any, ip: any) {

    let dbCoin = await coinType.prototype.findOne({
        where: {
            symbol: cronApplyVO.trigger_symbol
        },
        raw: true
    });
    if (!dbCoin) {
        throw ErrorCode.COIN_DATA_NOT_EXIST
    }
    cronApplyVO.trigger_type = 1;
    cronApplyVO.trigger_action = 1031;
    cronApplyVO.status = 0;
    cronApplyVO.createdAt = new Date();
    cronApplyVO.updatedAt = new Date();
    await systemTrigger.prototype.create(cronApplyVO);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '增加新币提现定时器', ip, JSON.stringify(cronApplyVO), '交易上下线管理');
    return 'success';
}


export async function addPairActive(cronApplyVO: CronApplyVO, currentUser: any, ip: any) {
    let pair = String(cronApplyVO.trigger_symbol);
    let dbPair: any;
    //合约
    if (pair.endsWith("_SWAP")) {
        dbPair = await contractPairs.prototype.findOne({
            where: {
                symbol: pair
            },
            raw: true
        });
    }
    else {
        dbPair = await spotPairs.prototype.findOne({
            where: {
                symbol: pair
            },
            raw: true
        });
    }

    if (!dbPair) {
        throw ErrorCode.PAIR_NOT_EXIST
    }

    if (dbPair.is_active == 1 && cronApplyVO.is_active == 1) {
        throw ErrorCode.PAIR_IS_ACTIVE;
    }
    if (dbPair.is_active == 0 && cronApplyVO.is_active != 1) {
        throw ErrorCode.PAIR_IS_NOT_ACTIVE;
    }

    delete cronApplyVO.is_active;

    cronApplyVO.trigger_type = 2;
    cronApplyVO.trigger_action = cronApplyVO.is_active == 1 ? 2011 : 2010;
    cronApplyVO.status = 0;
    cronApplyVO.createdAt = new Date();
    cronApplyVO.updatedAt = new Date();
    await systemTrigger.prototype.create(cronApplyVO);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '增加交易对激活定时器', ip, JSON.stringify(cronApplyVO), '交易上下线管理');
    return 'success';
}


export async function addPairHide(cronApplyVO: CronApplyVO, currentUser: any, ip: any) {

    let pair = String(cronApplyVO.trigger_symbol);
    let dbPair: any;
    //合约
    if (pair.endsWith("_SWAP")) {
        dbPair = await contractPairs.prototype.findOne({
            where: {
                symbol: pair
            },
            raw: true
        });
    }
    else {
        dbPair = await spotPairs.prototype.findOne({
            where: {
                symbol: pair
            },
            raw: true
        });
    }

    if (!dbPair) {
        throw ErrorCode.PAIR_NOT_EXIST
    }

    if (dbPair.is_hide == 1 && cronApplyVO.is_hide == 1) {
        throw ErrorCode.PAIR_IS_HIDE;
    }
    if (dbPair.is_hide == 0 && cronApplyVO.is_hide != 1) {
        throw ErrorCode.PAIR_IS_NOT_HIDE;
    }

    delete cronApplyVO.is_hide;

    cronApplyVO.trigger_type = 2;
    cronApplyVO.trigger_action = cronApplyVO.is_active == 1 ? 2021 : 2020;
    cronApplyVO.status = 0;
    cronApplyVO.createdAt = new Date();
    cronApplyVO.updatedAt = new Date();
    await systemTrigger.prototype.create(cronApplyVO);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '增加交易对隐藏定时器', ip, JSON.stringify(cronApplyVO), '交易上下线管理');
    return 'success';
}




