import * as noticeService from "../service/notice.service";
import { NoticeVO, NoticePageVO } from "../service/notice.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');

/**
 * 消息列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, noticePageVO: NoticePageVO) => {
    let func_name = "noticeCtrl.list";
    try {
        noticePageVO.page = Optional.opt(noticePageVO, 'page', 1);
        noticePageVO.size = Optional.opt(noticePageVO, 'size', 20);
        let res = await noticeService.list(noticePageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 新增消息
 * @param req
 * @param infoVO
 */
export const add = async (req: any, noticeVO: NoticeVO) => {
    let func_name = "noticeCtrl.add";
    try {

        ApiAssert.notNull(ErrorCode.PARAM_MISS, noticeVO.content);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, noticeVO.notice_type);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, noticeVO.push_time);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await noticeService.add(noticeVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 修改消息 删除 就传 del_sign = 1
 * 推送给指定的多个用户的消息 目前只能一个一个修改 不支持批量修改
 * 需要支持的话 可能数据库要调整 增加一个 group_id 字段
 * @param req
 * @param infoVO
 */
export const update = async (req: any, noticeVO: NoticeVO) => {
    let func_name = "noticeCtrl.update";
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, noticeVO.id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await noticeService.update(noticeVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
