import { ErrorCode } from "../../../../constant/errorCode";

export interface CommonParam {
    user_id?: number;

    page?: number,

    size?: number,

    from_time?: any,

    to_time?: any,

    query_type?: number//查询类型 1 现货 2 U本位合约 3 币本位合约 4 全部
}

export function setPageAndSize(commonParam: CommonParam) {
    commonParam.page = commonParam.page ? Number(commonParam.page) : 1;
    commonParam.size = commonParam.size ? Number(commonParam.size) : 20;
}

export function beforeQueryCheckTime(commonParam: CommonParam) {
    if (!commonParam.from_time || !commonParam.to_time) {
        throw ErrorCode.PARAM_MISS;
    }
}