import json
import logging
import time
import requests
from ..items import DefiLockedInfoItem
import scrapy
import xmltodict
import pprint

all_info_data = []
item = DefiLockedInfoItem()


class DefiComingEthSpider(scrapy.Spider):
    name = 'defi_coming_eth'
    # allowed_domains = ['www.xx.com']
    # start_urls = ['http://www.xx.com/']

    def __init__(self, *args, **kwargs):
        super(DefiComingEthSpider, self).__init__(*args, **kwargs)
        self.env = kwargs.get('env', 'online')
        self.start_num = 0
        self.dynamic_url = 'https://www.defibox.com/dgg/ranks/v3/all?lang=cn'
        self.headers = {
            "content-type": "application/json;charset=UTF-8"
        }
        self.page = 0
        self.request_payload_info = {
            "page": self.page,
            "size": 20,
            "chain": "eth",
            "vtoken": "0bca0f1778027e0626d56f4be3a9bb0a",
            "field": "locked",
            "direction": "DESC"
        }

    def start_requests(self):
        yield scrapy.Request(url=self.dynamic_url, callback=self.parse, method='POST',
                             body=json.dumps(self.request_payload_info), headers=self.headers)

    def parse(self, response):
        if response.status == 200:
            try:
                coverte_json = xmltodict.parse(response.text, encoding='utf-8')
                data_json = json.dumps(coverte_json)
                data_dict = json.loads(data_json)
                data_list = data_dict.get('R').get('data')
            except Exception as e:
                logging.info("***数据格式错误，解析异常，使用requests抓取json数据 ******")
                resp = requests.post(url=self.dynamic_url, json=self.request_payload_info, headers=self.headers)
                data_dict = resp.json()
                data_list = data_dict.get('data')
            if data_list:
                for data_item in data_list:
                    defi_item = dict()
                    defi_item['name'] = data_item['name']
                    try:
                        category_name = data_item.get('category').get('category').get('zh')
                        if category_name is None:
                            defi_item['chain_category_name'] = '其他'
                        elif category_name == '其他项目':
                            defi_item['chain_category_name'] = '其他'
                        else:
                            defi_item['chain_category_name'] = category_name
                    except Exception as e:
                        category_name = data_item.get('category')[0].get('zh')
                        if category_name is None:
                            defi_item['chain_category_name'] = '其他'
                        elif category_name == '其他项目':
                            defi_item['chain_category_name'] = '其他'
                        else:
                            defi_item['chain_category_name'] = category_name
                    defi_item['address_24h_num'] = data_item.get('address24')
                    defi_item['address_change_24h'] = data_item.get('address24Pct')
                    defi_item['volume_24h_usd'] = float(data_item.get('volume24'))
                    defi_item['volume_change_24h'] = data_item.get('volume24Pct')
                    defi_item['locked_usd'] = data_item.get('locked')
                    defi_item['locked_change_24h'] = data_item.get('lockedPct')
                    defi_item['chain_currency_id'] = 2
                    defi_item['website'] = data_item.get('website')
                    all_info_data.append(defi_item)

                if len(data_list) == 20:
                    self.page += 1
                    self.request_payload_info = {
                        "page": self.page,
                        "size": 20,
                        "chain": "eth",
                        "vtoken": "0bca0f1778027e0626d56f4be3a9bb0a",
                        "field": "locked",
                        "direction": "DESC"
                    }
                    yield scrapy.Request(url=self.dynamic_url, callback=self.parse, method='POST',
                                         body=json.dumps(self.request_payload_info), headers=self.headers)
                else:
                    item['data'] = all_info_data
                    yield item
            else:
                item['data'] = all_info_data
                yield item
