import scrapy
import json
from ..items import DefiLockedInfoItem
import requests

all_info_data = []
volume_24h_total = []


class DefiLockedEthSpider(scrapy.Spider):
    name = 'defi_locked_eth'
    start_num = 0
    # start_urls = ['https://static1.debank.com/tvl/projects-v2.json']

    def __init__(self, *args, **kwargs):
        super(DefiLockedEthSpider, self).__init__(*args, **kwargs)
        self.env = kwargs.get('env', 'online')
        self.tag_url = "https://api.debank.com/project/tag_list"
        self.base_url = "https://static1.debank.com/tvl/projects-v2.json"

    def start_requests(self):
        yield scrapy.Request(url=self.tag_url, callback=self.parse_tag)

    def parse_tag(self, response):
        if response.status == 200:
            tag_dict = {}
            tag_dict_list = json.loads(response.text)['data']['tag_list']
            for i in tag_dict_list:
                if i['id']:
                    tag_dict[i['id']] = i['name']['ch']
            yield scrapy.Request(url=self.base_url, callback=self.parse, meta={'tag_dict': tag_dict})

    def parse(self, response):
        if response.status == 200:
            data_dict = json.loads(response.text)
            tag_dict = response.meta['tag_dict']
            for data_item in data_dict:
                item = DefiLockedInfoItem()
                defi_item = dict()
                # if data_item['chain']['id'] == "eth":
                if data_item['chain'] == "eth":
                    defi_item['name'] = data_item['name']['en']
                    defi_item['contract_address'] = data_item.get('id') if data_item.get('id').startswith(
                        '0x') else '' if data_item.get('platform_token_id') is None else data_item.get(
                        'platform_token_id')
                    defi_item['lockup_category_name'] = '其他' if data_item.get('tag_ids') is None else '其他' if len(
                        data_item.get('tag_ids')) == 0 else tag_dict.get(
                        data_item.get('tag_ids')[0])
                    defi_item['volume_24h_usd'] = float(data_item.get('data')[-1].get('locked_usd_value'))
                    last_locked_amount = data_item.get('data')[-2].get('locked_usd_value')
                    if not last_locked_amount == 0:
                        defi_item['percent_change_24h'] = (defi_item[
                                                               'volume_24h_usd'] - last_locked_amount) / last_locked_amount
                    else:
                        defi_item['percent_change_24h'] = 0
                    defi_item['lock_currency_id'] = 2
                    all_info_data.append(defi_item)
                    volume_24h_total.append(defi_item['volume_24h_usd'])
                    self.start_num += 1
                    if self.start_num == 174:
                        item['data'] = all_info_data
                        # print(item)
                        # print('total:', sum(volume_24h_total))
                        return item
