import json
import time

import scrapy

from currency_follow import utils
from currency_follow.items import BitcoinTokenholdersTop100Item, BitcoinTokenHolderItem


class TokenholdersStdTop100Spider(scrapy.Spider):
    name = 'tokenholders_STD_top100'

    start_urls = ['http://47.57.70.99:8080/std/api/getTop100']

    def __init__(self, **kwargs):
        super(TokenholdersStdTop100Spider, self).__init__(**kwargs)
        self.env = kwargs.get('env', 'online')
        self.cpid, self.cid = 11750, 356455

    def parse(self, response):
        data_raws = json.loads(response.body.decode())
        item = BitcoinTokenholdersTop100Item()
        cpid, cid = self.cpid, self.cid
        bitem = BitcoinTokenHolderItem()
        holder_list = []
        rank = 1
        currency_price_usd = utils.get_currency_detail(cid).get('price_usd')
        for row in data_raws['data']['data']:
            row_dict = dict()
            row_dict['holder_rank'] = rank
            row_dict['address'] = row['address']
            row_dict['quantity'] = row['balance']
            row_dict['percentage'] = row['percent']
            row_dict['currency_id'] = cid
            row_dict['source_id'] = 3
            row_dict['note'] = ''
            row_dict['value'] = row['balance'] * currency_price_usd
            holder_list.append(row_dict)
            rank += 1
        item['holder_list'] = holder_list

        # # 获取持币地址数
        bitem['contract_address'] = 'address'
        bitem['holders'] = data_raws['data']['holders']
        bitem['holder_chart_url'] = 'https://explorer.standardchain.info/'
        bitem['currency_project_id'] = cpid
        bitem['utc0_date'] = int(time.time())
        item['bitcoin_tokenholders'] = bitem
        yield item
