# Define your item pipelines here
#
# Don't forget to add your pipeline to the ITEM_PIPELINES setting
# See: https://docs.scrapy.org/en/latest/topics/item-pipeline.html


# useful for handling different item types with a single interface
import redis

from . import utils
from .utils import update_grayscale_trust


class CurrencyFollowPipeline:
    def __init__(self):
        super(CurrencyFollowPipeline, self).__init__()
        self.eth20_redis = redis.StrictRedis(host='mt-cache.redis.rds.aliyuncs.com', db=0)
        # self.eth20_redis = redis.StrictRedis(host='localhost', db=0)

    def process_item(self, item, spider):
        if spider.name.startswith('grayscale'):
            self.process_grayscale_trust(item, spider)
            return item
        if spider.name in ['defi_coming_eth', 'defi_coming_heco', 'defi_coming_bsc']:
            self.process_defi_overview(item, spider)
        if spider.name in ['defi_locked_eth', 'defi_locked_heco']:
            self.process_defi_locked_info(item, spider)
        if spider.name in ['bitcoin_tokenholders_top100', 'tokenholders_STD_top100']:
            self.process_bitcoin_tokenholders_top100(item, spider)

    @staticmethod
    def process_bitcoin_tokenholders_top100(item, spider):
        if spider.env == 'demo':
            spider.logger.info(item)
        if spider.env == 'online':
            utils.update_bitcoin_top100(item)

    def process_grayscale_trust(self, item, spider):
        if spider.env == 'demo':
            print(item)
        if spider.env == 'online':
            self.eth20_redis.set("gray:grayscale_trust_" + item['currency_pet_name'], str(item['currency_etf']))
            utils.update_grayscale_trust(item)
            # print("成功post", item)

    @staticmethod
    def process_defi_overview(item, spider):
        if spider.env == 'demo':
            spider.logger.info(item)
            # utils.write_csv(item)
        if spider.env == 'online':
            utils.update_defi_overview(item)

    @staticmethod
    def process_defi_locked_info(item, spider):
        if spider.env == 'demo':
            spider.logger.info(item)
            # utils.write_csv(item)
        if spider.env == 'online':
            utils.update_defi_locked_info(item)