import scrapy
import json
import xmltodict
from ..items import DefiLockedInfoItem
import pprint
all_info_data = []
all_info_dict = {}


class DefiLockedHecoSpider(scrapy.Spider):
    name = 'defi_locked_heco'
    # allowed_domains = ['www.xx.com']
    # start_urls = ['http://www.xx.com/']

    def __init__(self, *args, **kwargs):
        super(DefiLockedHecoSpider, self).__init__(*args, **kwargs)
        self.env = kwargs.get('env', 'online')
        self.start_num = 0
        self.base_url = 'https://www.defibox.com/dgg/ranks/v3/all?lang=cn'
        self.new_url = 'https://m.defibox.com/-/x/dgg/quote/v2/deficoin/list?lang=cn'
        self.request_payload_info = {
            "page": 0,
            "size": 100,
            "chain": "heco",
            "vtoken": None,
            "field": "locked",
            "direction": "DESC"
        }
        self.payload = {"chain": "heco", "rule": "top", "size": 500}
        self.headers = {
            "content-type": "application/json;charset=UTF-8",
        }

    def start_requests(self):
        yield scrapy.FormRequest(url=self.base_url, callback=self.parse, method='POST',
                                 body=json.dumps(self.request_payload_info), headers=self.headers)

    def parse(self, response):
        if response.status == 200:
            coverte_json = xmltodict.parse(response.text, encoding='utf-8')
            data_json = json.dumps(coverte_json)
            data_dict = json.loads(data_json)
            # pprint.pprint(data_dict)
            data_list = data_dict['R']['data']
            for data_item in data_list:
                extId = data_item['extId']
                # defi_item = dict()
                name = data_item['name']
                # defi_item['contract_address'] = data_item.get('id') if data_item.get('id').startswith(
                #     '0x') else '' if data_item.get('platform_token_id') is None else data_item.get(
                #     'platform_token_id')
                try:
                    lockup_category_name = '其他' if data_item.get('category').get('category').get(
                        'zh') is None else data_item.get('category').get('category').get('zh')
                except:
                    lockup_category_name = '其他'
                all_info_dict[extId] = {'name': name, 'lockup_category_name': lockup_category_name}
                # defi_item['volume_24h_usd'] = float(data_item.get('locked'))
                # # last_locked_amount = data_item.get('locked')
                # defi_item['percent_change_24h'] = data_item['lockedPct']
                # defi_item['lock_currency_id'] = 3
            yield scrapy.FormRequest(url=self.new_url, method='POST', callback=self.parse_data,
                                     body=json.dumps(self.payload), headers=self.headers)

    def parse_data(self, response):
        if response.status == 200:
            coverte_json = xmltodict.parse(response.text, encoding='utf-8')
            data_json = json.dumps(coverte_json)
            data_dict = json.loads(data_json)
            # pprint.pprint(data_dict)
            data_list = data_dict['R']['data']
            for data_item in data_list:
                defi_info_item = dict()
                item = DefiLockedInfoItem()
                extId = data_item['extId']
                extId_1 = all_info_dict.get(extId)
                if extId_1:
                    defi_info_item['name'] = all_info_dict.get(extId)['name']
                    defi_info_item['lockup_category_name'] = all_info_dict[extId]['lockup_category_name']
                else:
                    defi_info_item['name'] = data_item['name'].capitalize()
                    defi_info_item['lockup_category_name'] = '其他'
                defi_info_item['volume_24h_usd'] = float(data_item.get('locked'))
                defi_info_item['percent_change_24h'] = data_item['priceChangePercentage24h']
                defi_info_item['lock_currency_id'] = 3
                all_info_data.append(defi_info_item)
                self.start_num += 1
                if self.start_num == len(data_list):
                    item['data'] = all_info_data
                    # print(sum([data.get('volume_24h_usd') for data in all_info_data]))
                    # print(item)
                    return item
