import json
import logging
import time

import grequests as grequests
import requests
from scrapy.utils.project import get_project_settings

from .settings import ApiUrl


# 比特币的
def update_bitcoin_top100(item):
    holder_list = item['holder_list']
    # 这里间接调用 新增持币地址数 方法。
    bitcoin_tokenholders = item['bitcoin_tokenholders']
    if bitcoin_tokenholders:
        update_etherscan_holders_info(bitcoin_tokenholders)
    if len(holder_list) > 0:
        request_list = []
        for row_dict in holder_list:
            rs = grequests.post(ApiUrl.UPLOAD_ETHERSCAN_TOP100, data=dict(row_dict))
            request_list.append(rs)
        try:
            ret = grequests.map(request_list, size=50, exception_handler=exception_handler)
            success_count = 0
            failed_count = 0
            for r in ret:
                if r.status_code == 200 and r.json()['code'] == 0:
                    success_count += 1
                else:
                    failed_count += 1
                    logging.info(
                        "***update_bitcoin_top100 failed! currency_id:{}, len_holder_list: {},ret_data:{}".format(
                            holder_list[0]['currency_id'],
                            len(holder_list),
                            r.content.decode()))
            logging.info(
                '***update_bitcoin_top100 status: currency_id:{}, len_holder_list: {}, success_count:{}, '
                'failed_count:{}'.format(
                    holder_list[0]['currency_id'], len(holder_list), success_count, failed_count))
        except Exception as e:
            logging.info("***update_bitcoin_top100 Exception:{}, holder_list:{}".format(e, holder_list))


def update_etherscan_holders_info(item):
    r = requests.post(ApiUrl.UPLOAD_ETHERSCAN_INFO, data=dict(item))
    if r.status_code == 200 and r.json()['code'] == 0:
        logging.info('***etherscan_holders update success: item: {}, ret_data:{}'.format(
            item, r.content.decode()))


def get_currency_detail(currency_id):
    r = requests.get(ApiUrl.GET_CURRENCY_DETAIL.format(currency_id))
    if r.status_code == 200 and r.json().get('code') == 0:
        return r.json().get('data')


def update_defi_locked_info(item):
    r = requests.post(ApiUrl.UPLOAD_DEFI_LOCKED_INFO, data=json.dumps(item['data']))
    if r.status_code == 200 and r.json().get('code') == 0:
        logging.info('***defi_locked_info update success: ret_data:{}'.format(r.content.decode()))
    else:
        post_to_wexin_qwxchat('项目:defi_locked_info 更新失败,ret_data:{}'.format(r.content.decode()))


def update_defi_overview(item):
    up_json = json.dumps(item['data'])
    # pprint.pprint(up_json)
    # print(up_json)
    r = requests.post(ApiUrl.UPLOAD_DEFI_OVERVIEW, data=up_json)
    if r.status_code == 200 and r.json().get('code') == 0:
        print('***defi_overview_info update success: ret_data:{}'.format(r.content.decode()))
        logging.info('***defi_overview_info update success: ret_data:{}'.format(r.content.decode()))
    else:
        print('***项目:defi_overview_info 更新失败,ret_data:{}'.format(r.content.decode()))
        post_to_wexin_qwxchat('项目:defi_overview_info 更新失败,ret_data:{}'.format(r.content.decode()))


def update_grayscale_trust(item):
    try:
        ts = int(time.time()) - 86400
        r = requests.post(
            ApiUrl.UPLOAD_GRAYSCALE_TRUST + "?ts={}&c={}&market_index_id={}".format(ts, item['currency_data'],
                                                                                    item['currency_id']))
        logging.info(
            '***update success:currency:{}, ret_data:{}, item:{}'.format(item['currency_name'], r.json(), item))
    except Exception as e:
        logging.info('***Exception:{}, item:{}'.format(e, item))


def post_to_wexin_qwxchat(content):
    url = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send"

    querystring = {"key": "67e59f56-81c7-4bf7-b35d-3bc7068981a6"}

    payload = {
        "msgtype": "text",
        "text": {
            "content": content,
            "mentioned_list": [],
            "mentioned_mobile_list": []
        }
    }
    headers = {
        'Content-Type': "application/json",
        'Cache-Control': "no-cache",
        'Host': "qyapi.weixin.qq.com",
        'Accept-Encoding': "gzip, deflate",
        'Content-Length': "359",
        'cache-control': "no-cache"
    }
    resp = requests.request("POST", url, data=json.dumps(payload), headers=headers, params=querystring)
    if resp.json()['errmsg'] == 'ok':
        print('发送成功')


def exception_handler(request, exception):
    logging.info(
        "***exception_handler,update_etherscan_top100 faile, exception:{}".format(exception))
