# Define here the models for your scraped items
#
# See documentation in:
# https://docs.scrapy.org/en/latest/topics/items.html

import scrapy


class BitcoinTokenholdersTop100Item(scrapy.Item):
    holder_list = scrapy.Field()
    bitcoin_tokenholders = scrapy.Field()


class BitcoinTokenHolderItem(scrapy.Item):
    holders = scrapy.Field()
    holder_chart_url = scrapy.Field()
    contract_address = scrapy.Field()
    currency_project_id = scrapy.Field()
    utc0_date = scrapy.Field()


class DefiLockedInfoItem(scrapy.Item):
    name = scrapy.Field()
    id = scrapy.Field()
    contract_address = scrapy.Field()
    lockup_category_name = scrapy.Field()
    volume_24h_usd = scrapy.Field()
    percent_change_24h = scrapy.Field()
    proportion = scrapy.Field()
    currency_id = scrapy.Field()
    # item_num = scrapy.Field()
    data = scrapy.Field()
    ts = scrapy.Field()
    volume_usd = scrapy.Field()


class GrayscaleTrustItem(scrapy.Item):
    currency_data = scrapy.Field()
    currency_name = scrapy.Field()
    currency_pet_name = scrapy.Field()
    currency_id = scrapy.Field()
    currency_etf = scrapy.Field()
