# Scrapy settings for currency_follow project
#
# For simplicity, this file contains only settings considered important or
# commonly used. You can find more settings consulting the documentation:
#
#     https://docs.scrapy.org/en/latest/topics/settings.html
#     https://docs.scrapy.org/en/latest/topics/downloader-middleware.html
#     https://docs.scrapy.org/en/latest/topics/spider-middleware.html
import os

BOT_NAME = 'currency_follow'

SPIDER_MODULES = ['currency_follow.spiders']
NEWSPIDER_MODULE = 'currency_follow.spiders'

REDIS_HOST_DOCKER = os.getenv('REDIS_HOST', 'r-j6cd64854a7eed94.redis.rds.aliyuncs.com')
REDIS_CACHE = 'mt-core-data.redis.rds.aliyuncs.com'
REDIS_PORT = '6379'

# Crawl responsibly by identifying yourself (and your website) on the user-agent
USER_AGENT = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) ' \
             'Chrome/90.0.4430.85 Safari/537.36 '

# Obey robots.txt rules
ROBOTSTXT_OBEY = False

LOG_LEVEL = 'INFO'


class ApiUrl(object):
    API_BASE = os.getenv('API_BASE_HOST', 'http://172.16.0.147:12306')  # 正式环境

    REDIS_CORE = os.getenv('REDIS_CORE', 'mt-core-data.redis.rds.aliyuncs.com')
    API_007 = os.getenv('API_NEW_ALFRED_HOST', 'http://dataapi.mytokenapi.com')

    UPLOAD_GRAYSCALE_TRUST = '{}/marketindex/create'.format(API_BASE)
    UPLOAD_BITCOIN_MININ_DATA = '{}/mining/create'.format('http://172.16.6.98:12306')

    # API_BASE = "http://beta.internal.mytokenio.com"  # 办公司访问 香港阿里云测试环境

    API_BASE_BETA = 'http://172.17.1.63:12306'  # 香港阿里云测试环境
    API_BASE_PRE = 'http://172.16.6.98:12306'  # 香港阿里云PRE环境
    # API_BASE = "http://beta.internal.mytoken-local.com"  # 香港阿里云测试环境
    # API_BASE = 'http://hkbeta.manageapi.mytoken.org'  # 香港阿里云测试环境

    # API_BASE = 'http://172.16.0.147:12306'  # 香港阿里云正式环境(备份)
    # API_BASE = 'http://52.56.166.200:12306'  # AWS正式环境(废弃)
    # API_BASE = 'http://35.176.110.161:12306'  # AWS测试环境(废弃)
    # 上传新闻资讯接口:
    UPLOAD_FOREIGN_MEDIA = '{}/news/create'.format(API_BASE)
    # 获取currency(项目)信息接口:
    GET_SOCIAL_TARGET = API_BASE + '/currencyproject/list?page_num={}&page_limit=200'
    # 获取currency_detail
    GET_CURRENCY_DETAIL = API_BASE + '/currency/currencydetail?market_id=1303&currency_id={}'
    # 上传currency(项目方)社交媒体数据:
    UPLOAD_SOCIAL_INFO = '{}/currencysummary/create'.format(API_BASE)
    # 获取交易所信息接口:
    # UPLOAD_USDT_VOL = '{}/usdtvol/updateorinsert'.format(API_BASE)
    UPLOAD_USDT_VOL = '{}/usdtvol/insert'.format(API_BASE)

    MARKET_LIST = '{}/market/marketlist?source=script'.format(API_BASE)
    # 上传交易所排名基础数据
    UPLOAD_MARKET_RANK = '{}/marketrank/bcreate'.format(API_BASE)
    # 上传defi数据
    UPLOAD_DEFI_LOCKED_INFO = '{}/defi/lockupupsert'.format(API_BASE)
    UPLOAD_DEFI_OVERVIEW = '{}/deficity/currencycreate'.format(API_BASE_PRE)
    UPLOAD_ETHERSCAN_TOP100 = '{}/currencyethereumaddress/create'.format(API_BASE)
    UPLOAD_ETHERSCAN_INFO = '{}/currencyproject/blockchainupdate'.format(API_BASE)
    UPLOAD_DEFI_DEX = '{}/defi/dexupupsert'.format(API_BASE)
    UPLOAD_DEFI_DEBT = '{}/defi/loanupupsert'.format(API_BASE)
    UPLOAD_DEFI_RATE = '{}/defi/ratecreate'.format(API_BASE)
    # 上传NFT数据
    UPLOAD_NFT_INFO = '{}/nft/create'.format(API_BASE_PRE)
    # 获取mytoken
    GET_MYTOKEN = "{}/common/getqntoken".format(API_BASE)
    # 上传快讯
    UPLOAD_NEWS_FLASH = "{}/newsflash/add".format(API_BASE)
    GET_ETHERSCAN_TARGET = API_BASE + '/currencyproject/list?page_limit=100&page_num={}'
    # 链接redis
    REDIS_DATA = os.getenv("REDIS_DATA", 'r-j6cd64854a7eed94.redis.rds.aliyuncs.com')
    REDIS_DATA_DB = int(os.getenv("REDIS_DATA_DB", 7))
    REDIS_TTL = int(os.getenv("REDIS_TTL", 900))
    REDIS_KEY = os.getenv("REDIS_KEY", "media_cache_{}:{}")
    ERROR_ACCOUNT_KEY = os.getenv("ERROR_ACCOUNT_KEY", "error_account:{}:{}")
    UPLOAD_ETHERSCAN_ADDRESS_OVERVIEW = '{}/exchangebalancesnapshot/create'.format(API_BASE)
    GET_ALL_ADDRESS = 'http://172.16.3.188:8001/getAllAddresses?type={}&enabled=1'


# Configure maximum concurrent requests performed by Scrapy (default: 16)
# CONCURRENT_REQUESTS = 32

# Configure a delay for requests for the same website (default: 0)
# See https://docs.scrapy.org/en/latest/topics/settings.html#download-delay
# See also autothrottle settings and docs
# DOWNLOAD_DELAY = 3
# The download delay setting will honor only one of:
# CONCURRENT_REQUESTS_PER_DOMAIN = 16
# CONCURRENT_REQUESTS_PER_IP = 16

# Disable cookies (enabled by default)
COOKIES_ENABLED = False

# Disable Telnet Console (enabled by default)
# TELNETCONSOLE_ENABLED = False

# Override the default request headers:
# DEFAULT_REQUEST_HEADERS = {
#   'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
#   'Accept-Language': 'en',
# }

# Enable or disable spider middlewares
# See https://docs.scrapy.org/en/latest/topics/spider-middleware.html
# SPIDER_MIDDLEWARES = {
#    'currency_follow.middlewares.CurrencyFollowSpiderMiddleware': 543,
# }

# Enable or disable downloader middlewares
# See https://docs.scrapy.org/en/latest/topics/downloader-middleware.html
DOWNLOADER_MIDDLEWARES = {
   'currency_follow.middlewares.CloudScraperMiddleware': 543,
}

# Enable or disable extensions
# See https://docs.scrapy.org/en/latest/topics/extensions.html
# EXTENSIONS = {
#    'scrapy.extensions.telnet.TelnetConsole': None,
# }

# Configure item pipelines
# See https://docs.scrapy.org/en/latest/topics/item-pipeline.html
ITEM_PIPELINES = {
   'currency_follow.pipelines.CurrencyFollowPipeline': 300,
}

# Enable and configure the AutoThrottle extension (disabled by default)
# See https://docs.scrapy.org/en/latest/topics/autothrottle.html
# AUTOTHROTTLE_ENABLED = True
# The initial download delay
# AUTOTHROTTLE_START_DELAY = 5
# The maximum download delay to be set in case of high latencies
# AUTOTHROTTLE_MAX_DELAY = 60
# The average number of requests Scrapy should be sending in parallel to
# each remote server
# AUTOTHROTTLE_TARGET_CONCURRENCY = 1.0
# Enable showing throttling stats for every response received:
# AUTOTHROTTLE_DEBUG = False

# Enable and configure HTTP caching (disabled by default)
# See https://docs.scrapy.org/en/latest/topics/downloader-middleware.html#httpcache-middleware-settings
# HTTPCACHE_ENABLED = True
# HTTPCACHE_EXPIRATION_SECS = 0
# HTTPCACHE_DIR = 'httpcache'
# HTTPCACHE_IGNORE_HTTP_CODES = []
# HTTPCACHE_STORAGE = 'scrapy.extensions.httpcache.FilesystemCacheStorage'
