# Define here the models for your spider middleware
#
# See documentation in:
# https://docs.scrapy.org/en/latest/topics/spider-middleware.html

# useful for handling different item types with a single interface


from scrapy.http import HtmlResponse


class CloudScraperMiddleware:
    def process_response(self, request, response, spider):
        if response.status == 403:
            if spider.name == "grayscale_trust":
                url = request.url
                req = spider.scraper.get(url, headers={'referer': url})
                # time.sleep(5)
                return HtmlResponse(url=url, body=req.text, encoding="utf-8", request=request)
        return response