import json
import logging
import re

import cloudscraper
import scrapy

from ..items import GrayscaleTrustItem


class GrayscaleTrustSpider(scrapy.Spider):
    name = 'grayscale_trust'

    # allowed_domains = ['www.cx.com']
    # start_urls = ['http://www.cx.com/']

    def __init__(self, *args, **kwargs):
        super(GrayscaleTrustSpider, self).__init__(*args, **kwargs)
        self.env = kwargs.get('env', 'online')
        self.base_url = "https://grayscale.co/{}-trust/"
        self.currency_info_list = [("basic-attention-token", 37, "bat"), ("bitcoin", 28, "btc"),
                                   ("bitcoin-cash", 33, "bch"),
                                   ("chainlink", 38, "link"), ('decentraland', 40, "mana"), ("ethereum", 29, "eth"),
                                   ("ethereum-classic", 32, "etc"), ('filecoin', 39, "fil"), ("horizen", 34, "zen"),
                                   ("litecoin", 30, "ltc"), ('livepeer', 41, "lpt"), ("stellar-lumens", 36, "lum"),
                                   ("zcash", 35, "zch")]
        self.scraper = cloudscraper.create_scraper()
        # self.scraper = cfscrape.create_scraper()

    def start_requests(self):
        for currency_info in self.currency_info_list:
            currency_re_url = self.base_url.format(currency_info[0])
            yield scrapy.Request(url=currency_re_url, callback=self.parse,
                                 meta={"currency_name": currency_info[0], "currency_id": currency_info[1],
                                       "pet_name": currency_info[2]})

    def parse(self, response):
        currency_name = response.meta['currency_name']
        currency_id = response.meta['currency_id']
        pet_name = response.meta['pet_name']
        if response.status == 200:
            item = GrayscaleTrustItem()
            try:
                shares_Outstanding = response.xpath(
                    '//span[@data-title="Shares Outstanding"]/text()').get()[:-1]
                currency_per_Share = response.xpath(
                    '//span[@data-title="Token per Share"]/text()').get()[:-1]
                shares_Outstanding = int(''.join(shares_Outstanding.split(',')))
                currency_per_Share = float(currency_per_Share)

                # json_data = json.loads(
                #     re.search(r'chart_data_(.*?)window', response.text, re.S | re.I).group(1).split('=')[-1][:-2])
                json_str = re.search(r'window\[\'chart_data_.*?\'] = (.*?);', response.text, re.S | re.I).group(1)
                json_data = json.loads(json_str)
                market_price_per_share = json_data["Benchmark"][-1]['y']
                if currency_id in (28, 29, 30, 33, 32):
                    currency_etf = float(market_price_per_share) / float(currency_per_Share)
                else:
                    currency_etf = 0
            except Exception as e:
                # print('-----------------------------------------', currency_name)
                logging.error("{}页面解析出错，原因：{}".format(currency_name, e))
            else:
                item['currency_id'] = currency_id
                item['currency_name'] = currency_name
                item['currency_pet_name'] = pet_name
                item['currency_data'] = shares_Outstanding * currency_per_Share
                item['currency_etf'] = currency_etf
                yield item
