/**
 * useful_link表常量。
 */
export const IS_ACTIVE = {
    /**
     * 是否启用： 未启用。
     */
    IS_ACTIVE_NO: 0,
    /**
     * 是否启用： 已启用。
     */
    IS_ACTIVE_YES: 1
}
export const IS_ACTIVE_ARR = [IS_ACTIVE.IS_ACTIVE_NO, IS_ACTIVE.IS_ACTIVE_YES]

export const LINK_TYPE = {
    /**
     * 友情链接。
     */
    TYPE_NORMAL: 1,

    /**
     * 合作伙伴。
     */
    TYPE_FRIEND: 2,

    /**
     * 公告。
     */
    TYPE_NOTICE: 3,

    /**
     * 轮播图。
     */
    TYPE_SLIDESHOW: 4,

    /**
     * app 轮播图。
     */
    TYPE_SLIDESHOW_APP: 5,

    /**
     * 鼓励金比例管理。
     */
    TYPE_BIX_LOCK_BACK_RATE: 6,

    /**
     * app 弹窗。
     */
    TYPE_APP_POP: 8,

    /**
     * web 弹框。
     */
    TYPE_WEB_POP: 9,

    /**
     * banner, 首页活动 banner。
     */
    TYPE_BANNER: 10,

    /**
     * 活动中心。
     */
    TYPE_ACTIVE_CENTER: 11,

    /**
     * 广告位： 红包页面。
     */
    TYPE_ADVERTISE_RED_PACKET: 12,

    /**
     * 广告位： web交易页，币对位置。
     */
    TYPE_ADVERTISE_WEB_PAIR: 13,

    /**
     * 广告位： 登录页面。
     */
    TYPE_ADVERTISE_LOGIN: 14,

    /**
     * 广告位： 系统邮件。
     */
    TYPE_ADVERTISE_SYS_MAIL: 15,

    /**
     * 标题广告： 币币交易详情页。
     */
    TYPE_DETAIL_TRADE_SPOT: 16,

    /**
     * 标题广告： 杠杆交易详情页。
     */
    TYPE_DETAIL_TRADE_CREDIT: 17,

    /**
     * 标题广告： 合约交易详情页。
     */
    TYPE_DETAIL_TRADE_CONTRACT: 18,

    /**
     * 合约轮播图。
     */
    TYPE_SLIDESHOW_CONTRACT: 19,

    /**
     * 合约公告
     */
    TYPE_NOTICE_CONTRACT: 20,
}

export const LINK_TYPE_ARR = [
    LINK_TYPE.TYPE_NORMAL,
    LINK_TYPE.TYPE_FRIEND,
    LINK_TYPE.TYPE_NOTICE,
    LINK_TYPE.TYPE_SLIDESHOW,
    LINK_TYPE.TYPE_SLIDESHOW_APP,
    LINK_TYPE.TYPE_BIX_LOCK_BACK_RATE,
    LINK_TYPE.TYPE_APP_POP,
    LINK_TYPE.TYPE_WEB_POP,
    LINK_TYPE.TYPE_BANNER,
    LINK_TYPE.TYPE_ACTIVE_CENTER,
    LINK_TYPE.TYPE_ADVERTISE_RED_PACKET,
    LINK_TYPE.TYPE_ADVERTISE_WEB_PAIR,
    LINK_TYPE.TYPE_ADVERTISE_LOGIN,
    LINK_TYPE.TYPE_ADVERTISE_SYS_MAIL,
    LINK_TYPE.TYPE_DETAIL_TRADE_SPOT,
    LINK_TYPE.TYPE_DETAIL_TRADE_CREDIT,
    LINK_TYPE.TYPE_DETAIL_TRADE_CONTRACT,
    LINK_TYPE.TYPE_SLIDESHOW_CONTRACT,
    LINK_TYPE.TYPE_NOTICE_CONTRACT,
]
