import * as service from "../service/coinType.service";
import { AddParam, ListParam } from "../service/coinType.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');


export const list = async (req: any, param: ListParam) => {
    let func_name = "coinTypeCtl.list";
    let cmd = req.path;
    try {
        param.page = Optional.opt(param, 'page', 1);
        param.size = Optional.opt(param, 'size', 50);
        let res = await service.list(param);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const save = async (req: any, param: AddParam) => {
    let func_name = "coinTypeCtl.save";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.symbol);
        ApiAssert.notNull('3000', param.name);
        ApiAssert.notNull('3000', param.general_name);
        ApiAssert.isInt('3000', param.is_active);
        ApiAssert.isInt('3000', param.is_main);
        ApiAssert.isInt('3000', param.original_decimals);
        ApiAssert.isInt('3000', param.valid_decimals);
        ApiAssert.isInt('3000', param.deposit_confirm_count);
        ApiAssert.isInt('3000', param.safe_confirm_count);

        let res = await service.save(param);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


export const pushToCoreSystem = async (req: any, id: any) => {
    let func_name = "coinTypeCtl.pushToCoreSystem";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', id);
        let res = await service.pushToCoreSystem(id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
