import { ormDB, hotPairConfig } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";



let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface HotPairConfigVO {
    id?: number;

    pair?: string | any;

    weight?: number;

    createdAt?: Date | any;

    updatedAt?: Date | any;


}

export interface HotPairConfigPageVO extends HotPairConfigVO {
    page?: number,

    size?: number
}

export async function list(pair: any, page: number, size: number) {
    let where = Object.create(null);
    if (pair) {
        where.pair = { [ormDB.Op.like]: `${pair}%` };
    }

    let resList = await hotPairConfig.prototype.findAndCount({
        where: where,
        limit: size,
        offset: (page - 1) * size,
        order: [["weight", "desc"]],
        raw: true
    });
    return resList;
}

export async function add(hotPairConfigVO: HotPairConfigVO) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            pair: hotPairConfigVO.pair
        },
        raw: true
    });

    if (dbInfo) {
        throw ErrorCode.DATA_EXIST;
    }
    hotPairConfigVO.createdAt = new Date();
    hotPairConfigVO.updatedAt = new Date();

    await hotPairConfig.prototype.create(hotPairConfigVO);
    return 'success'
}


export async function update(hotPairConfigVO: HotPairConfigVO) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            pair: hotPairConfigVO.pair,
            id: { [ormDB.Op.ne]: hotPairConfigVO.id }
        },
        raw: true
    });

    if (dbInfo) {
        throw ErrorCode.DATA_EXIST;
    }
    hotPairConfigVO.updatedAt = new Date();

    await hotPairConfig.prototype.update({
        pair: hotPairConfigVO.pair,
        weight: hotPairConfigVO.weight
    }, {
        where: {
            id: Number(hotPairConfigVO.id)
        }
    });
    return 'success'
}


export async function del(id: number) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });

    if (!dbInfo) {
        throw ErrorCode.DATA_NOT_EXIST;
    }

    await hotPairConfig.prototype.destroy({
        where: {
            id: Number(id)
        }
    });
    return 'success'
}



