import { ormDB, userLog, userProfile } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { getProfileByUserIds } from "./mUserProfile.service";

let _ = require('lodash');
let { logger, datetimeUtils } = require('@madex/ex-js-public');

export const MUserLogType = {
    UP_EMAIL: 25,//运营修改用户邮箱
}
export interface QueryVO {

    page?: number,

    size?: number

    user_id?: number | any;

    place?: string | any;

    type?: number;

    start_date?: Date | any;

    end_date?: Date | any;


}


export async function list(queryVO: QueryVO) {
    let where = Object.create(null);
    if (queryVO.user_id) {
        where.user_id = queryVO.user_id;
    }

    if (queryVO.type) {
        where.type = queryVO.type;
    }

    if (queryVO.start_date && queryVO.end_date) {
        let from = datetimeUtils.trim(queryVO.start_date, 's');
        let to = datetimeUtils.trim(queryVO.end_date, 's');
        where.createdAt = { [ormDB.Op.between]: [from, to] };
    }

    let resList = await userLog.prototype.findAndCount({
        where: where,
        limit: queryVO.size,
        offset: (Number(queryVO.page) - 1) * Number(queryVO.size),
        order: [["id", "desc"]],
        raw: true
    });
    if (resList.rows.length > 0) {
        let uids = resList.rows.map(item => item.user_id);
        let profileMap = await getProfileByUserIds(_.uniq(uids));
        for (let item of resList.rows) {
            let oneProfileInfo = profileMap[item.user_id];
            item.nick_name = oneProfileInfo ? (oneProfileInfo.nick_name ? oneProfileInfo.nick_name : "") : "";
        }
    }

    return resList;
}

export const addLog = async function (m_user_id: number, type: number, ip: string, operator: number, comment: string) {
    userLog.prototype.create({
        user_id: m_user_id,
        type: type,
        user_ip: ip,
        device_id: operator,
        comment: comment,
        createdAt: new Date(),
        updatedAt: new Date(),
    })
}




