/**
 * 登录过滤
 */

const {
    Res3Utils,
    logger: Logger,
} = require("@madex/ex-js-public");
import * as ReqUtils from "../utils/req-utils"

const CLASS_NAME = "login-filter";

const ExcludeApi = {
    "user/login": 1,
    "user/logout": 1,
    "user/login/confirm": 1,
    "mUser/fee/vip/level/list": 1,
    "spotPair/getAllSubmitSuccess": 1,
    "coinType/getAllSubmitSuccess": 1,
    'acl/role/getAll': 1,
    'position/allList': 1,
    'department/allList': 1,
    'operate/other/business/area/list': 1,
};
//管理员需要强制绑定，该位置做特殊处理
const AdminExcludeApi = {
    "user/bind/totp/ask": 1,
    "user/bind/totp/confirm": 1,
}

let filter = function (app: any) {
    app.use(function (req, res, next) {
        let path = ReqUtils.parsePath(req.originalUrl);
        try {
            //如果是非登录接口，可以直接跳过

            if (ExcludeApi[path] || path.indexOf("bastard") > 0) {
                next();
            }
            else {
                let cookies = req.cookies
                ReqUtils
                    .checkCookie(cookies, AdminExcludeApi[path], path, req)
                    .then(() => next())
                    .catch(e => res.json(Res3Utils.getErrorResult(e)))
            }
        }
        catch (e) {
            Logger.error(`${CLASS_NAME} filter error!! - ${e}`);
            return res.json(Res3Utils.getErrorResult(e));
        }
    });
};

module.exports = {
    filter: filter,
};
