import { FEE_STATUS, FEE_TYPE } from "../../src/constant/marketMakerConst";

let { logger } = require('@madex/ex-js-public');

let {
    spotFeeStatusCheck, contractFeeStatusCheck, baseCoinContractFeeStatusCheck,
    findUserFeeDataNeed2Active, findUserFeeDataNeed2Expire, userFeeSettingStatusUpdate
} = require('../model/task.fee.setting.status.update.model');

/**
 * 币币、合约费率设置记录状态。
 */
import { FEE_RATE_LOG_STATUS } from "../../src/constant/feeRateLogConst";


/****************************************** 普通用户费率设置状态更新相关操作。 **********************************************/

/**
 * 市商、普通用户、KOL 费率状态更新。
 * @returns {Promise<void>}
 */
export const commonUserFeeSettingStatusUpdateService = async function (ctime = new Date()) {
    try {
        await commonUserStatusUpdate();
    }
    catch (error) {
        logger.error(' commonUserFeeSettingStatusUpdate error ', error);
    }
    logger.warn(' commonUserFeeSettingStatusUpdate ', ctime, ' stat over ');
};

/**
 * 状态扫描和更新。
 * @returns {Promise<void>}
 */
async function commonUserStatusUpdate() {
    let [data2Submit, data2Expire] = await Promise.all([findUserFeeDataNeed2Active(), findUserFeeDataNeed2Expire()]);
    await userDataCheckAndUpdate(data2Submit);
    await userDataCheckAndUpdate(data2Expire);
}

/**
 * 检查数据情况并更新状态。
 * @param data
 * @returns {Promise<void>}
 */
async function userDataCheckAndUpdate(data) {
    if (data === null || data.length === 0) {
        return;
    }

    for (let i = 0, len = data.length; i < len; i++) {
        let item = data[i];
        let id = item.id;
        let logIds = item.fee_log_ids;
        let idArr = logIds.split(",");

        if (idArr === null || idArr.length === 0) {
            logger.error("commonUserFeeSettingStatusUpdate.userDataCheckAndUpdate log id parse fail! id: %s", id);
            continue;
        }

        // 根据记录id确定该设置项的状态。
        let logId = idArr[0];
        let feeStatusData;
        if (Number(item.type) === FEE_TYPE.FEE_TYPE_SPOT) {
            feeStatusData = await spotFeeStatusCheck(logId);
        }
        else if (Number(item.type) === FEE_TYPE.FEE_TYPE_CONTRACT) {
            feeStatusData = await contractFeeStatusCheck(logId);
        }
        else if (Number(item.type) === FEE_TYPE.FEE_TYPE_BASE_COIN_CONTRACT) {
            feeStatusData = await baseCoinContractFeeStatusCheck(logId);
        }
        if (feeStatusData === null) {
            logger.error("commonUserFeeSettingStatusUpdate.userDataCheckAndUpdate fee setting record miss! " +
                "id: %s, logId: %s", id, logId);
            continue;
        }


        let status = item.status;
        let statusNew = status;
        let feeStatus = Number(feeStatusData.is_check);
        switch (feeStatus) {
            case FEE_RATE_LOG_STATUS.CHECK_STATUS_ACTIVE:
                statusNew = FEE_STATUS.STATUS_FEE_SETTING_EFFECTED;
                break;
            case FEE_RATE_LOG_STATUS.CHECK_STATUS_ACTIVE_OVER:
                statusNew = FEE_STATUS.STATUS_FEE_SETTING_EXPIRE;
                break;
            case FEE_RATE_LOG_STATUS.CHECK_STATUS_DELETED:
                statusNew = FEE_STATUS.STATUS_FEE_SETTING_DELETED;
                break;
            default:
                continue;
        }
        if (statusNew !== status) {
            await userFeeSettingStatusUpdate(id, statusNew);
            logger.info("commonUserFeeSettingStatusUpdate.userDataCheckAndUpdate log(%s) status updated. %s -> %s",
                id, status, statusNew);
        }
    }
}