let express = require('express');
let errorHandler = require('errorhandler');
let logger = require("@madex/ex-js-public").logger;

import configSetting from "./config"
import { apiRouterV1 } from "./src/functional/router/v1/index"
import { apiRouterV2 } from "./src/functional/router/v2/index"

/* ======================================================================
 * Config
 * ====================================================================== */
let app = express();

logger.use(app);
// express 全局设定
require('@madex/ex-js-common').expressSetting(app);
// Request frequency limit
const limitList = [

];
require("@madex/ex-js-common").frequencyLimiting.cookieLimitForCmd(app, limitList);

require("@madex/ex-js-common").apiExceedAlertUtils.check(app, { projectNO: 20, expireTime: 1000 }) // 检查

require("./src/setting/access-limit").filter(app);
require("./src/setting/login-filter").filter(app);
require("./src/setting/abk-login-filter").filter(app);


if (configSetting.node_env == "development") {
    app.use(errorHandler());
}
else {
    app.use(function (err, req, resp, next) {
        logger.warn('500 error ', err);
        return resp.status(500).send();
    });
}


app.use(configSetting.BASE_URL,apiRouterV1);
app.use(configSetting.BASE_ABK_URL,apiRouterV2);



//启动Server
// app.listen(configSetting.port, function () {
//     // logger.info("Wallet Gateway-(bibox_b020_southgatetoheaven) server listening on %d, in %s mode", configSetting.port, app.get("env"));
//     // wxUtils.serviceStartSend('bibox_b020_southgatetoheaven');
// });

// 输出进程错误
process.on('uncaughtException', (error) => {
    let error_msg = JSON.stringify(error)
    logger.error("uncaughtException:", error_msg)
})

// 输出未捕获异常
process.on('unhandledRejection', (error, promise) => {
    promise.catch(err => {
        logger.warn("unhandledRejection:", JSON.stringify(err.message))
    })
});

// console.log(configSetting)
app.listen(configSetting.port, '0.0.0.0', () => {
    logger.info(
        'backend',
        configSetting.port,
        app.get('env'),
    );
});
