import { AppVersionPageVO } from "../service/appVersion.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { ADDRESS_INFO_REDIS_KEY, ADDRESS_INFO_REDIS_KEY_OBJ, APP_VERSION_KEY } from "../../../constant/redis-val";
import { addOptLog } from "../service/userOptLog.service";

let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');

let isIp = require('is-ip');

interface ParamVO {
    host?: string,

    isObj?: number
}

/**
 * app动态域名获取详情
 * @param req
 * @param infoVO
 */
export const get = async (req: any, paramVO: ParamVO) => {
    let func_name = "appDynamicDomain.control.get";
    try {
        let isObj = Number(paramVO.isObj);

        let data = isObj == 1 ? await RedisClient.getSync(ADDRESS_INFO_REDIS_KEY_OBJ) : await RedisClient.getSync(ADDRESS_INFO_REDIS_KEY);

        return Res3Utils.result(data);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * app动态域名设置详情
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, paramVO: ParamVO) => {
    let func_name = "appDynamicDomain.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let host = String(paramVO.host);
        let isObj = Number(paramVO.isObj);
        if (!host) {
            throw ErrorCode.PARAM_MISS
        }

        if (isObj == 1) {
            let hostObj = JSON.parse(host);
            let hostArr = hostObj.hosts;
            if (!hostArr.length) {
                throw ErrorCode.PARAM_MISS
            }

            let hostString = hostArr[0];
            let sharesArr = hostObj.shares;
            if (!sharesArr.length) {
                throw ErrorCode.PARAM_MISS
            }

            let shareString = sharesArr[0];
            let apiHostArr = hostObj.apiHosts;
            if (!apiHostArr.length) {
                throw ErrorCode.PARAM_MISS
            }

            let oldPush = hostObj.oldPush;
            let newPush = hostObj.newPush;

            let data = {
                host: hostString,
                hosts: hostArr,
                share: shareString,
                shares: sharesArr,
                oldPush: oldPush,
                newPush: newPush,
                apiHosts: apiHostArr
            }
            await RedisClient.writeSync(ADDRESS_INFO_REDIS_KEY, hostString);
            await RedisClient.writeSync(ADDRESS_INFO_REDIS_KEY_OBJ, JSON.stringify(data));

        }
        else {
            await RedisClient.writeSync(ADDRESS_INFO_REDIS_KEY, host);
        }

        //管理后台操作日志
        addOptLog(currentUserId, 0, 'App动态域名设置', ip, `Host:${host}`, 'App动态域名');
        return Res3Utils.result('ok');
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

