import * as appVersionService from "../service/appVersion.service";
import { AppVersionVO, AppVersionPageVO } from "../service/appVersion.service";



let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { DEVICE_ARR, PLATFORM_ARR, STATUS_ARR } from "../../../constant/appVersionConstant";

let isIp = require('is-ip');
/**
 * app版本列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: AppVersionPageVO) => {
    let func_name = "appVersion.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await appVersionService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加新的App版本
 * @param req
 * @param authConfigVO
 */
export const add = async (req: any, appVersionVO: AppVersionVO) => {
    let func_name = "appVersion.control.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(appVersionVO);

        let res = await appVersionService.add(appVersionVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 修改用户App版本
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, appVersionVO: AppVersionVO) => {
    let func_name = "appVersion.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!appVersionVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        await paramValid(appVersionVO);

        let res = await appVersionService.update(appVersionVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


async function paramValid(appVersionVO: AppVersionVO) {
    if (!appVersionVO.version || !appVersionVO.version_url || !appVersionVO.download_url) {
        throw ErrorCode.PARAM_MISS
    }
    if (!DEVICE_ARR.includes(Number(appVersionVO.device_type)) || !STATUS_ARR.includes(Number(appVersionVO.status))
        || !PLATFORM_ARR.includes(Number(appVersionVO.platform))) {
        throw ErrorCode.PARAM_MISS
    }

    if (!appVersionVO.grayscale_value || appVersionVO.grayscale_value < 0) {
        appVersionVO.grayscale_value = 0
    }
    else {
        if (appVersionVO.grayscale_value > 100) {
            appVersionVO.grayscale_value = 10
        }
    }


}

