import * as mUserOptLogService from "../service/mUserOptLog.service";
import { QueryVO } from "../service/mUserOptLog.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";

/**
 * Madex 用户操作日志列表 （目前没用）
 * @param req
 * @param infoVO
 */
export const list = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserOptLogCtrl.list";
    try {
        queryVO.page = Optional.opt(queryVO, 'page', 1);
        queryVO.size = Optional.opt(queryVO, 'size', 20);
        let res = await mUserOptLogService.list(queryVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
