'use strict';

const schedule = require('node-schedule');
const config = require('../../config');

import * as triggerSvr from "../service/task.system.trigger.service";

const AHEAD_TIME_ALLOWED = 2000; //允许提前时间

import * as RobotUtil from "../../src/utils/robotUtils";


/**
 *  每5秒监控一次交易对设置变化
 */

let jobTrigger = function () {
    schedule.scheduleJob('*/2 * * * * *', async function () {
        try {
            let triggerList = await triggerSvr.getExPairUnTriggers();
            let nowTime = new Date();
            console.log('jobExPairTrigger  trigger at ', nowTime);
            let hasTriggered: any = false;
            for (let item of triggerList) {
                if (new Date(item.trigger_time).getTime() - AHEAD_TIME_ALLOWED <= nowTime.getTime()) {
                    let rtn = await triggerSvr.doExPairTrigger(item.id, item.trigger_symbol, item.trigger_action);
                    hasTriggered |= rtn;
                    RobotUtil.sendRobotMessage(RobotUtil.ROBOT_KEYS.COMMON_KEY,
                        `${config.env} 触发交易对更新-${item.trigger_symbol}:${item.trigger_action}--${rtn}`);
                }
            }
            //更新redis交易对信息
            if (hasTriggered) {
                triggerSvr.updateRedisPairs();
            }

        }
        catch (e) {
            console.error('jobExPairTrigger fail:', e);
        }
    });

    /**
     * 币种表触发 每分钟触发
     */
    schedule.scheduleJob('*/1 * * * *', async function () {
        try {

            let triggerList = await triggerSvr.getCoinTypeUnTriggers();
            let nowTime = new Date();
            console.log('jobExPairTrigger  trigger at ', nowTime);
            for (let item of triggerList) {
                if (new Date(item.trigger_time).getTime() - AHEAD_TIME_ALLOWED <= nowTime.getTime()) {
                    let rtn = await triggerSvr.doCoinTypeTrigger(item.id, item.trigger_symbol, item.trigger_action);
                    RobotUtil.sendRobotMessage(RobotUtil.ROBOT_KEYS.COMMON_KEY,
                        `${config.env} 触发币种更新-${item.trigger_symbol}:${item.trigger_action}--${rtn}`);
                }
            }

        }
        catch (e) {
            console.error('jobExPairTrigger fail:', e);
        }
    });
}

jobTrigger();