import * as exBusinessAreaService from "../service/exBusinessArea.service";
import { BusinessAreaVO, BusinessAreaPageVO, AreaRouterVO } from "../service/exBusinessArea.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * 运营部-其他管理-交易区设置列表-不分页
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: BusinessAreaPageVO) => {
    let func_name = "exBusinessArea.control.list";
    try {
        let res = await exBusinessAreaService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 运营部-其他管理-添加交易区设置
 * @param req
 * @param authConfigVO
 */
export const add = async (req: any, businessAreaVO: BusinessAreaVO) => {
    let func_name = "exBusinessArea.control.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(businessAreaVO);

        let res = await exBusinessAreaService.add(businessAreaVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 运营部-其他管理-添加交易区设置修改
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, businessAreaVO: BusinessAreaVO) => {
    let func_name = "exBusinessArea.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!businessAreaVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        await paramValid(businessAreaVO);

        let res = await exBusinessAreaService.update(businessAreaVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 运营部-其他管理-添加交易区设置删除
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, businessAreaVO: BusinessAreaVO) => {
    let func_name = "exBusinessArea.control.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!businessAreaVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await exBusinessAreaService.del(businessAreaVO.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 运营部-其他管理-交易区设置树状结构
 * @param req
 * @param infoVO
 */
export const getTree = async (req: any, pageVO: BusinessAreaPageVO) => {
    let func_name = "exBusinessArea.control.getTree";
    try {
        let res = await exBusinessAreaService.getTree();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 运营部-其他管理-币种所属交易区设置列表
 * @param req
 * @param infoVO
 */
export const routerList = async (req: any, pageVO: BusinessAreaPageVO) => {
    let func_name = "exBusinessArea.control.routerList";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await exBusinessAreaService.routerList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 运营部-其他管理-币种所属交易区设置添加
 * @param req
 * @param authConfigVO
 */
export const routerAdd = async (req: any, areaRouterVO: AreaRouterVO) => {
    let func_name = "exBusinessArea.control.routerAdd";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await routerParamValid(areaRouterVO);

        let res = await exBusinessAreaService.routerAdd(areaRouterVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 运营部-其他管理-币种所属交易区设置修改
 * @param req
 * @param authConfigVO
 */
export const routerUpdate = async (req: any, areaRouterVO: AreaRouterVO) => {
    let func_name = "exBusinessArea.control.routerUpdate";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!areaRouterVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        await routerParamValid(areaRouterVO);

        let res = await exBusinessAreaService.routerUpdate(areaRouterVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 运营部-其他管理-币种所属交易区设置删除
 * @param req
 * @param authConfigVO
 */
export const routerDel = async (req: any, areaRouterVO: AreaRouterVO) => {
    let func_name = "exBusinessArea.control.routerDel";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!areaRouterVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await exBusinessAreaService.routerDel(areaRouterVO.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

async function paramValid(businessAreaVO: BusinessAreaVO) {
    let name = businessAreaVO.name;
    let icon_url = businessAreaVO.icon_url;
    if (!name || !icon_url) {
        throw ErrorCode.PARAM_MISS
    }
}

async function routerParamValid(areaRouterVO: AreaRouterVO) {
    let pair = areaRouterVO.pair;
    let area_id = areaRouterVO.area_id;
    let weight = areaRouterVO.weight;
    if (!pair || !area_id) {
        throw ErrorCode.PARAM_MISS
    }
    if (!weight) {
        areaRouterVO.weight = 0
    }

}

