import * as cronApplyService from "../service/spotData.service";
import { QueryVO } from "../service/spotData.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');

let isIp = require('is-ip');
/**
 * 运营部-现货-现货数据-新增用户
 * @param req
 * @param infoVO
 */
export const increaseUserList = async (req: any, pageVO: QueryVO) => {
    let func_name = "spotData.control.increaseUserList";
    try {
        //初始化查询参数
        initParam(pageVO);
        let res = await cronApplyService.increaseUserList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 运营部-现货-现货数据-新增用户
 * @param req
 * @param infoVO
 */
export const tradeUserList = async (req: any, pageVO: QueryVO) => {
    let func_name = "spotData.control.tradeUserList";
    try {
        //初始化查询参数
        initParam(pageVO);
        let res = await cronApplyService.tradeUserList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 运营部-现货-现货数据-活跃用户
 * @param req
 * @param infoVO
 */
export const activeUserList = async (req: any, pageVO: QueryVO) => {
    let func_name = "spotData.control.activeUserList";
    try {
        //初始化查询参数
        initParam(pageVO);
        let res = await cronApplyService.activeUserList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 运营部-现货-现货数据-充值额
 * @param req
 * @param infoVO
 */
export const userDepositList = async (req: any, pageVO: QueryVO) => {
    let func_name = "spotData.control.userDepositList";
    try {
        //初始化查询参数
        initParam(pageVO);
        let res = await cronApplyService.userDepositList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 运营部-现货-现货数据-提现额
 * @param req
 * @param infoVO
 */
export const userWithdrawList = async (req: any, pageVO: QueryVO) => {
    let func_name = "spotData.control.userWithdrawList";
    try {
        //初始化查询参数
        initParam(pageVO);
        let res = await cronApplyService.userWithdrawList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 运营部-现货-现货数据-净充值额
 * @param req
 * @param infoVO
 */
export const userDepositAndWithdrawList = async (req: any, pageVO: QueryVO) => {
    let func_name = "spotData.control.userDepositAndWithdrawList";
    try {
        //初始化查询参数
        initParam(pageVO);
        let res = await cronApplyService.userDepositAndWithdrawList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



/**
 * 运营部-现货-现货数据-数据汇总
 * @param req
 * @param infoVO
 */
export const gatherData = async (req: any, pageVO: QueryVO) => {
    let func_name = "spotData.control.gatherData";
    try {
        //初始化查询参数
        initParam(pageVO);
        let res = await cronApplyService.gatherData(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};






function initParam(pageVO: QueryVO) {
    pageVO.page = Optional.opt(pageVO, 'page', 1);
    pageVO.size = Optional.opt(pageVO, 'size', 20);
    let now = new Date();
    let today = datetimeUtils.trim(now, 'd');
    let yesterday = datetimeUtils.sub(today, datetimeUtils.DAY);
    if (!pageVO.from_time) {
        pageVO.from_time = yesterday;
    }
    if (!pageVO.to_time) {
        pageVO.to_time = today;
    }
}



