import * as usefulLinkService from "../service/usefulLink.service";
import { UsefulLinkVO, UsefulLinkPageVO } from "../service/usefulLink.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { IS_ACTIVE, IS_ACTIVE_ARR, LINK_TYPE_ARR } from "../../../constant/usefulLinkConst";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * 分页查询链接列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, usefulLinkPageVO: UsefulLinkPageVO) => {
    let func_name = "usefulLinkCtrl.list";
    try {
        usefulLinkPageVO.page = Optional.opt(usefulLinkPageVO, 'page', 1);
        usefulLinkPageVO.size = Optional.opt(usefulLinkPageVO, 'size', 20);
        let res = await usefulLinkService.list(usefulLinkPageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加链接
 * @param req
 * @param infoVO
 */
export const add = async (req: any, usefulLinkVO: UsefulLinkVO) => {
    let func_name = "usefulLinkCtrl.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(usefulLinkVO);
        let res = await usefulLinkService.add(usefulLinkVO, currentUserId, ip);

        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 修改链接
 * @param req
 * @param infoVO
 */
export const update = async (req: any, usefulLinkVO: UsefulLinkVO) => {
    let func_name = "usefulLinkCtrl.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(usefulLinkVO);
        let res = await usefulLinkService.update(usefulLinkVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 删除链接
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, usefulLinkVO: UsefulLinkVO) => {
    let func_name = "usefulLinkCtrl.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, usefulLinkVO.id);
        let res = await usefulLinkService.del(Number(usefulLinkVO.id), currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 链接详情
 * @param req
 * @param authConfigVO
 */
export const detail = async (req: any, usefulLinkVO: UsefulLinkVO) => {
    let func_name = "usefulLinkCtrl.detail";
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, usefulLinkVO.id);
        let res = await usefulLinkService.detail(Number(usefulLinkVO.id));
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


async function paramValid(usefulLinkVO: UsefulLinkVO) {
    let type = Number(usefulLinkVO.type);
    let active = Number(usefulLinkVO.is_active);
    if (!usefulLinkVO.name || !usefulLinkVO.url || !type || isNaN(Number(active))
        || !usefulLinkVO.weight || !usefulLinkVO.comment) {
        throw ErrorCode.PARAM_MISS;
    }
    if (!IS_ACTIVE_ARR.includes(active) || !LINK_TYPE_ARR.includes(type)) {
        throw ErrorCode.PARAM_MISS;
    }
}