
import { addOptLog, } from "./userOptLog.service";
import { getCollaterals, setCollateral } from "../../../utils/coreSystemUtils";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface VO {
    order?: number;

    discount?: string | any;

    symbol?: string | any;

    collateral?: boolean | any;

}


export async function list() {
    return await getCollaterals();
}

export async function save(vo: VO, currentUserId: any, ip: string | undefined) {

    await setCollateral(vo.symbol, vo.discount, vo.order, vo.collateral);


    addOptLog(currentUserId, 0, '配置抵扣', ip, JSON.stringify(vo), '配置抵扣');

    return 'success'
}
