/**
 * 资产管理后台登录过滤
 */
import Config from "../../config";

const {
    Res3Utils,
    logger: Logger,
} = require("@madex/ex-js-public");
import * as ReqUtils from "../utils/req-utils"

const CLASS_NAME = "login-filter";

const ExcludeApi = {
    "abkUser/login": 1,
    "abkUser/logout": 1,
};


let filter = function (app: any) {
    app.use(function (req, res, next) {
        let path = req.originalUrl;
        let pathR = req.originalUrl.replace(Config.BASE_ABK_URL,"");
        try {
            // Madex 管理后台的接口 跳过
            if (ExcludeApi[pathR] || path.startsWith(Config.BASE_URL)) {
                next();
            }
            else {
                let cookies = req.cookies
                ReqUtils
                    .checkAbkCookie(cookies,req)
                    .then(() => next())
                    .catch(e => res.json(Res3Utils.getErrorResult(e)))
            }
        }
        catch (e) {
            Logger.error(`${CLASS_NAME} abk-login-filter error!! - ${e}`);
            return res.json(Res3Utils.getErrorResult(e));
        }
    });
};

module.exports = {
    filter: filter,
};
